/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContentAction
extends AnAction
implements DumbAware {
    protected final ContentManager myManager;
    protected final ShadowAction myShadow;

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction shortcutTemplate, @NotNull @NlsActions.ActionText String text, @NotNull Disposable parentDisposable) {
        super(text);
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, shortcutTemplate, manager.getComponent(), new Presentation(text), parentDisposable);
    }

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction template, @NotNull Disposable parentDisposable) {
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, template, manager.getComponent(), parentDisposable);
    }

    public static class MyPreviousTabAction
    extends TabbedContentAction {
        public MyPreviousTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("PreviousTab"), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.selectPreviousContent();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getPreviousContentActionName());
        }
    }

    public static final class MyNextTabAction
    extends TabbedContentAction {
        public MyNextTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("NextTab"), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.selectNextContent();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getNextContentActionName());
        }
    }

    public static final class CloseAllAction
    extends TabbedContentAction {
        public CloseAllAction(@NotNull ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("CloseAllEditors"), UIBundle.message((String)"tabbed.pane.close.all.action.name", (Object[])new Object[0]), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            for (Content content2 : this.myManager.getContents()) {
                if (!content2.isCloseable()) continue;
                this.myManager.removeContent(content2, true);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabledAndVisible(this.myManager.getContentCount() > 1 && this.myManager.canCloseAllContents());
        }
    }

    public static class CloseAllButThisAction
    extends ForContent {
        public CloseAllButThisAction(@NotNull Content content2) {
            super(content2, ActionManager.getInstance().getAction("CloseAllEditorsButActive"), UIBundle.message((String)"tabbed.pane.close.all.but.this.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Content[] contents;
            for (Content content2 : contents = this.myManager.getContents()) {
                if (this.myContent == content2 || !content2.isCloseable()) continue;
                this.myManager.removeContent(content2, true);
            }
            this.myManager.setSelectedContent(this.myContent);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setText(this.myManager.getCloseAllButThisActionName());
            presentation2.setEnabledAndVisible(this.myManager.canCloseContents() && this.hasOtherCloseableContents());
        }

        private boolean hasOtherCloseableContents() {
            Content[] contents;
            for (Content content2 : contents = this.myManager.getContents()) {
                if (this.myContent == content2 || !content2.isCloseable()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CloseAction
    extends ForContent {
        public CloseAction(@NotNull Content content2) {
            super(content2, ActionManager.getInstance().getAction("CloseActiveTab"));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.removeContent(this.myContent, true);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabledAndVisible(this.myManager.canCloseContents() && this.myContent.isCloseable());
            presentation2.setText(this.myManager.getCloseActionName());
        }
    }

    public static abstract class ForContent
    extends TabbedContentAction {
        @NotNull
        protected final Content myContent;

        public ForContent(@NotNull Content content2, @NotNull AnAction shortcutTemplate, String text) {
            super(content2.getManager(), shortcutTemplate, text, (Disposable)content2);
            this.myContent = content2;
        }

        public ForContent(@NotNull Content content2, AnAction template) {
            super(content2.getManager(), template, (Disposable)content2);
            this.myContent = content2;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myManager.getIndexOfContent(this.myContent) >= 0);
        }
    }
}

