/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance(ContentManagerImpl.class);
    private ContentUI myUI;
    private final List<Content> myContents = new ArrayList<Content>();
    private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
    private final List<Content> mySelection = new ArrayList<Content>();
    private final boolean myCanCloseContents;
    private JPanel myComponent;
    private final Set<Content> myContentWithChangedComponent = new HashSet<Content>();
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders = new SmartList();
    private final ArrayList<Content> mySelectionHistory = new ArrayList();

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project) {
        this(contentUI, canCloseContents, project, (Disposable)project);
    }

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project, @NotNull Disposable parentDisposable) {
        this(canCloseContents, project, parentDisposable, (ContentManager contentManager2, Supplier<JPanel> componentGetter) -> {
            ((ContentManagerImpl)contentManager2).myUI = contentUI;
            contentUI.setManager(contentManager2);
            return contentUI;
        });
    }

    @ApiStatus.Experimental
    public ContentManagerImpl(boolean canCloseContents, @NotNull Project project, @NotNull Disposable parentDisposable, @NotNull ContentUiProducer contentUiProducer) {
        ContentUI ui;
        this.myProject = project;
        this.myCanCloseContents = canCloseContents;
        this.myUI = ui = contentUiProducer.createContent(this, () -> {
            LOG.assertTrue(this.myComponent == null);
            this.myComponent = new MyNonOpaquePanel();
            return this.myComponent;
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        if (ui instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)ui));
        }
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            this.myComponent.add((Component)this.myUI.getComponent(), "Center");
        }
        return this.myComponent;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Content selected2 = this.getSelectedContent();
        if (selected2 == null) {
            return ActionCallback.DONE;
        }
        BusyObject busyObject = selected2.getBusyObject();
        return busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
    }

    public void addContent(@NotNull Content content2, int order) {
        this.doAddContent(content2, order);
    }

    public void addContent(@NotNull Content content2) {
        this.doAddContent(content2, -1);
    }

    private void doAddContent(@NotNull Content content2, int index) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content2)) {
            this.myContents.remove(content2);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content2);
            return;
        }
        ((ContentImpl)content2).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content2);
        content2.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content2, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content2);
            } else {
                this.addSelectedContent(content2);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content2);
    }

    public boolean removeContent(@NotNull Content content2, boolean dispose2) {
        boolean wasFocused = UIUtil.isFocusAncestor((Component)content2.getComponent());
        return this.removeContent(content2, dispose2, wasFocused, false).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content2, boolean dispose2, boolean requestFocus, boolean forcedFocus) {
        ActionCallback result2 = new ActionCallback();
        this.doRemoveContent(content2, dispose2).doWhenDone(() -> {
            if (requestFocus) {
                Content current2 = this.getSelectedContent();
                if (current2 != null) {
                    this.setSelectedContent(current2, true, true, !forcedFocus).notify(result2);
                } else {
                    ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                    result2.setDone();
                }
            } else {
                result2.setDone();
            }
        });
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ActionCallback doRemoveContent(@NotNull Content content2, boolean dispose2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int indexToBeRemoved = this.getIndexOfContent(content2);
        if (indexToBeRemoved == -1) {
            return ActionCallback.REJECTED;
        }
        try {
            int newSize;
            int selectedIndex;
            Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
            int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
            if (!this.fireContentRemoveQuery(content2, indexToBeRemoved) || !content2.isValid()) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                return actionCallback;
            }
            boolean wasSelected = this.isSelected(content2);
            if (wasSelected) {
                this.removeFromSelection(content2);
            }
            int indexToSelect = -1;
            if (wasSelected) {
                int i2 = indexToBeRemoved - 1;
                if (i2 >= 0) {
                    indexToSelect = i2;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
            } else if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
            this.mySelectionHistory.remove(content2);
            this.myContentWithChangedComponent.remove(content2);
            this.myContents.remove(content2);
            content2.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireContentRemoved(content2, indexToBeRemoved);
            ((ContentImpl)content2).setManager(null);
            if (dispose2) {
                Disposer.dispose((Disposable)content2);
            }
            if ((newSize = this.myContents.size()) > 0) {
                if (indexToSelect > -1) {
                    Content toSelect2;
                    Content content3 = toSelect2 = !this.mySelectionHistory.isEmpty() ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                    if (!this.isSelected(toSelect2)) {
                        if (this.myUI.isSingleSelection()) {
                            ActionCallback result2 = new ActionCallback();
                            this.setSelectedContentCB(toSelect2).notify(result2);
                            ActionCallback actionCallback = result2;
                            return actionCallback;
                        }
                        this.addSelectedContent(toSelect2);
                    }
                }
            } else {
                this.mySelection.clear();
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            return actionCallback;
        }
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed && this.myContents.isEmpty()) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose2) {
        if (this.myContents.isEmpty()) {
            return;
        }
        for (Content content2 : new ArrayList<Content>(this.myContents)) {
            this.removeContent(content2, dispose2);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    public Content @NotNull [] getContents() {
        return this.myContents.toArray(new Content[0]);
    }

    public Content findContent(String displayName) {
        for (Content content2 : this.myContents) {
            if (!content2.getDisplayName().equals(displayName)) continue;
            return content2;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(@NotNull JComponent component2) {
        Content[] contents;
        for (Content content2 : contents = this.getContents()) {
            if (!Comparing.equal((Object)component2, (Object)content2.getComponent())) continue;
            return content2;
        }
        return null;
    }

    public int getIndexOfContent(@NotNull Content content2) {
        return this.myContents.indexOf(content2);
    }

    @NotNull
    public String getCloseActionName() {
        return this.myUI.getCloseActionName();
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        return this.myUI.getCloseAllButThisActionName();
    }

    @NotNull
    public String getPreviousContentActionName() {
        return this.myUI.getPreviousContentActionName();
    }

    @NotNull
    public String getNextContentActionName() {
        return this.myUI.getNextContentActionName();
    }

    @NotNull
    public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
        return Collections.emptyList();
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content2 : this.myContents) {
            if (!content2.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content2) {
        if (!this.checkSelectionChangeShouldBeProcessed(content2, false)) {
            return;
        }
        if (this.getIndexOfContent(content2) == -1) {
            throw new IllegalArgumentException("content not found: " + content2);
        }
        if (!this.isSelected(content2)) {
            this.mySelection.add(content2);
            this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(@NotNull Content content2, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content2, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content2) || this.myContentWithChangedComponent.contains(content2);
        this.myContentWithChangedComponent.remove(content2);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content2) {
        if (!this.isSelected(content2)) {
            return;
        }
        this.mySelection.remove(content2);
        this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content2) {
        return this.mySelection.contains(content2);
    }

    public Content @NotNull [] getSelectedContents() {
        return this.mySelection.toArray(new Content[0]);
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus) {
        this.setSelectedContentCB(content2, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus) {
        return this.setSelectedContentCB(content2, requestFocus, true);
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        this.setSelectedContentCB(content2, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        return this.setSelectedContent(content2, requestFocus, forcedFocus, false);
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content2, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        this.mySelectionHistory.remove(content2);
        this.mySelectionHistory.add(0, content2);
        if (this.isSelected(content2) && requestFocus) {
            return this.getFocusManager().requestFocus((Component)this.getComponent(), true).doWhenProcessed(() -> this.requestFocus(content2, forcedFocus));
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, implicit)) {
            return ActionCallback.REJECTED;
        }
        if (!this.myContents.contains(content2)) {
            throw new IllegalArgumentException("Cannot find content:" + content2.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content2) == -1) {
                    return ActionCallback.REJECTED;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content2);
                if (requestFocus) {
                    ContentManagerImpl.this.requestFocus(content2, forcedFocus);
                }
                return ActionCallback.DONE;
            }
        };
        ActionCallback result2 = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if ((focused || requestFocus) && enabledFocus) {
            return this.getFocusManager().requestFocusInProject((Component)this.getComponent(), this.myProject).doWhenProcessed(() -> selection.run().notify(result2));
        }
        return selection.run().notify(result2);
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((Component)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2) {
        return this.setSelectedContentCB(content2, false);
    }

    public void setSelectedContent(@NotNull Content content2) {
        this.setSelectedContentCB(content2);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(@NotNull Content content2, int newIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(@NotNull Content content2, int oldIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(@NotNull Content content2, ContentManagerEvent.ContentOperation operation) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.getIndexOfContent(content2), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content2, int oldIndex) {
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.undefined);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content2, boolean forced) {
        Content toSelect2;
        Content content3 = toSelect2 = content2 == null ? this.getSelectedContent() : content2;
        if (toSelect2 == null) {
            return ActionCallback.REJECTED;
        }
        assert (this.myContents.contains(toSelect2));
        JComponent preferredFocusableComponent = toSelect2.getPreferredFocusableComponent();
        return preferredFocusableComponent != null ? this.getFocusManager().requestFocusInProject((Component)preferredFocusableComponent, this.myProject) : ActionCallback.REJECTED;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        this.dataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        return (ContentFactory)ServiceManager.getService(ContentFactory.class);
    }

    public void beforeTreeDispose() {
        if (!this.myDisposed) {
            this.myUI.beforeDispose();
        }
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
        this.myComponent = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private final class MyNonOpaquePanel
    extends JPanel
    implements DataProvider {
        MyNonOpaquePanel() {
            super(new BorderLayout());
            this.setOpaque(false);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data2 = dataProvider.getData(dataId);
                if (data2 == null) continue;
                return data2;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider = DataManager.getDataProvider((JComponent)this);
            return provider == null ? null : provider.getData(dataId);
        }
    }

    public static interface ContentUiProducer {
        public ContentUI createContent(@NotNull ContentManager var1, @NotNull @NotNull Supplier<@NotNull JPanel> var2);
    }
}

