/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.DefaultLinkButtonUIKt;
import com.intellij.ui.components.UnderlinedView;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.StringReader;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.Document;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\u001a\u0015\u0010\u0019\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\u001a\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a*\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002\u001a$\u0010)\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u00122\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020*0,H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0013\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"defaultColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "disabledColor", "hoveredColor", "pressedColor", "sharedEditorKit", "com/intellij/ui/components/DefaultLinkButtonUIKt$sharedEditorKit$2$1", "getSharedEditorKit", "()Lcom/intellij/ui/components/DefaultLinkButtonUIKt$sharedEditorKit$2$1;", "sharedEditorKit$delegate", "Lkotlin/Lazy;", "sharedUnderlineStyles", "Ljavax/swing/text/html/StyleSheet;", "getSharedUnderlineStyles", "()Ljavax/swing/text/html/StyleSheet;", "sharedUnderlineStyles$delegate", "underlineStyles", "", "visitedColor", "createUnderlinedView", "Ljavax/swing/text/View;", "button", "Ljavax/swing/AbstractButton;", "text", "getColor", "isEnabled", "", "isHovered", "isPressed", "isUnderlined", "isUpdateable", "property", "", "isVisited", "layoutText", "fm", "Ljava/awt/FontMetrics;", "textBounds", "Ljava/awt/Rectangle;", "iconBounds", "readSafely", "", "read", "Lkotlin/Function1;", "Ljava/io/StringReader;", "intellij.platform.ide.impl"})
public final class DefaultLinkButtonUIKt {
    private static final Color defaultColor = JBUI.CurrentTheme.Link.linkColor();
    private static final Color hoveredColor = JBUI.CurrentTheme.Link.linkHoverColor();
    private static final Color pressedColor = JBUI.CurrentTheme.Link.linkPressedColor();
    private static final Color visitedColor = JBUI.CurrentTheme.Link.linkVisitedColor();
    private static final Color disabledColor = JBUI.CurrentTheme.Label.disabledForeground();
    private static final String underlineStyles = "\np { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nbody { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nfont {text-decoration: underline}\n";
    private static final Lazy sharedUnderlineStyles$delegate = LazyKt.lazy((Function0)sharedUnderlineStyles.2.INSTANCE);
    private static final Lazy sharedEditorKit$delegate = LazyKt.lazy((Function0)sharedEditorKit.2.INSTANCE);

    private static final String layoutText(AbstractButton button2, FontMetrics fm, Rectangle textBounds, Rectangle iconBounds) {
        Rectangle viewBounds = new Rectangle(button2.getWidth(), button2.getHeight());
        JBInsets.removeFrom((Rectangle)viewBounds, (Insets)button2.getInsets());
        return SwingUtilities.layoutCompoundLabel(button2, fm, button2.getText(), button2.getIcon(), button2.getVerticalAlignment(), button2.getHorizontalAlignment(), button2.getVerticalTextPosition(), button2.getHorizontalTextPosition(), viewBounds, iconBounds, textBounds, button2.getText() == null ? 0 : button2.getIconTextGap());
    }

    private static final boolean isUpdateable(Object property) {
        return property == null || property instanceof UIResource;
    }

    private static final boolean isEnabled(AbstractButton button2) {
        ButtonModel buttonModel = button2.getModel();
        return buttonModel != null ? buttonModel.isEnabled() : false;
    }

    private static final boolean isHovered(AbstractButton button2) {
        ButtonModel buttonModel = button2.getModel();
        return buttonModel != null ? buttonModel.isRollover() : false;
    }

    private static final boolean isPressed(AbstractButton button2) {
        boolean bl;
        ButtonModel buttonModel = button2.getModel();
        if (buttonModel != null) {
            ButtonModel buttonModel2 = buttonModel;
            boolean bl2 = false;
            boolean bl3 = false;
            ButtonModel it = buttonModel2;
            boolean bl4 = false;
            bl = it.isArmed() && it.isPressed();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isVisited(AbstractButton button2) {
        AbstractButton abstractButton = button2;
        if (!(abstractButton instanceof ActionLink)) {
            abstractButton = null;
        }
        ActionLink actionLink = (ActionLink)abstractButton;
        return actionLink != null ? actionLink.getVisited() : false;
    }

    private static final boolean isUnderlined(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isHovered(button2) || button2.isFocusPainted() && button2.hasFocus();
    }

    private static final Color getColor(AbstractButton button2) {
        return !DefaultLinkButtonUIKt.isEnabled(button2) ? disabledColor : (DefaultLinkButtonUIKt.isPressed(button2) ? pressedColor : (DefaultLinkButtonUIKt.isHovered(button2) ? hoveredColor : (DefaultLinkButtonUIKt.isVisited(button2) ? visitedColor : defaultColor)));
    }

    private static final View createUnderlinedView(AbstractButton button2, String text) {
        StyleSheet styles = new StyleSheet();
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedUnderlineStyles());
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedEditorKit().getStyleSheet());
        styles.addRule(UIUtilities.displayPropertiesToCSS((Font)button2.getFont(), (Color)button2.getForeground()));
        HTMLDocument document = new HTMLDocument(styles);
        document.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        document.setPreservesUnknownTags(false);
        Object base = button2.getClientProperty("html.base");
        if (base instanceof URL) {
            document.setBase((URL)base);
        }
        DefaultLinkButtonUIKt.readSafely(text, (Function1<? super StringReader, Unit>)((Function1)new Function1<StringReader, Unit>(document){
            final /* synthetic */ HTMLDocument $document;

            public final void invoke(@NotNull StringReader it) {
                DefaultLinkButtonUIKt.access$getSharedEditorKit$p().read(it, (Document)this.$document, 0);
            }
            {
                this.$document = hTMLDocument;
                super(1);
            }
        }));
        return new UnderlinedView(button2, DefaultLinkButtonUIKt.getSharedEditorKit().getViewFactory().create(document.getDefaultRootElement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void readSafely(String text, Function1<? super StringReader, Unit> read) {
        try (StringReader reader = new StringReader(text);){
            read.invoke((Object)reader);
        }
    }

    private static final StyleSheet getSharedUnderlineStyles() {
        Lazy lazy = sharedUnderlineStyles$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (StyleSheet)lazy.getValue();
    }

    private static final sharedEditorKit.1 getSharedEditorKit() {
        Lazy lazy = sharedEditorKit$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return lazy.getValue();
    }

    public static final /* synthetic */ boolean access$isUpdateable(Object property) {
        return DefaultLinkButtonUIKt.isUpdateable(property);
    }

    public static final /* synthetic */ String access$layoutText(AbstractButton button2, FontMetrics fm, Rectangle textBounds, Rectangle iconBounds) {
        return DefaultLinkButtonUIKt.layoutText(button2, fm, textBounds, iconBounds);
    }

    public static final /* synthetic */ boolean access$isPressed(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isPressed(button2);
    }

    public static final /* synthetic */ boolean access$isUnderlined(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isUnderlined(button2);
    }

    public static final /* synthetic */ boolean access$isEnabled(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isEnabled(button2);
    }

    public static final /* synthetic */ View access$createUnderlinedView(AbstractButton button2, String text) {
        return DefaultLinkButtonUIKt.createUnderlinedView(button2, text);
    }

    public static final /* synthetic */ boolean access$isHovered(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isHovered(button2);
    }

    public static final /* synthetic */ Color access$getColor(AbstractButton button2) {
        return DefaultLinkButtonUIKt.getColor(button2);
    }

    public static final /* synthetic */ sharedEditorKit.1 access$getSharedEditorKit$p() {
        return DefaultLinkButtonUIKt.getSharedEditorKit();
    }

    public static final /* synthetic */ void access$readSafely(String text, Function1 read) {
        DefaultLinkButtonUIKt.readSafely(text, (Function1<? super StringReader, Unit>)read);
    }
}

