/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.colorpicker.ColorPickerModelKt;
import com.intellij.ui.picker.ColorListener;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fJ\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00032\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0001J\u0006\u0010-\u001a\u00020&J\u0006\u0010.\u001a\u00020&J\u000e\u0010/\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fJ\u001a\u00100\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00032\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000e\u00a8\u00061"}, d2={"Lcom/intellij/ui/colorpicker/ColorPickerModel;", "", "originalColor", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "alpha", "", "getAlpha", "()I", "blue", "getBlue", "brightness", "", "getBrightness", "()F", "<set-?>", "color", "getColor", "()Ljava/awt/Color;", "green", "getGreen", "hex", "", "getHex", "()Ljava/lang/String;", "hsb", "", "hue", "getHue", "instantListeners", "", "Lcom/intellij/ui/picker/ColorListener;", "listeners", "red", "getRed", "saturation", "getSaturation", "addListener", "", "listener", "invokeOnEveryColorChange", "", "applyColorToSource", "newColor", "source", "onCancel", "onClose", "removeListener", "setColor", "intellij.platform.ide.impl"})
public final class ColorPickerModel {
    private final Set<ColorListener> listeners;
    private final Set<ColorListener> instantListeners;
    @NotNull
    private Color color;
    private final float[] hsb;

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color newColor, @Nullable Object source) {
        this.color = newColor;
        Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.hsb);
        Iterable $this$forEach$iv = this.instantListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void setColor$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.setColor(color, object);
    }

    public final void onClose() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ ColorPickerModel this$0;

            public final void run() {
                Iterable $this$forEach$iv = ColorPickerModel.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ColorListener it = (ColorListener)element$iv;
                    boolean bl = false;
                    it.colorChanged(this.this$0.getColor(), (Object)this.this$0);
                }
            }
            {
                this.this$0 = colorPickerModel;
            }
        });
    }

    public final void onCancel() {
    }

    public final void applyColorToSource(@NotNull Color newColor, @Nullable Object source) {
        this.setColor(newColor, source);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void applyColorToSource$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.applyColorToSource(color, object);
    }

    public final int getRed() {
        return this.color.getRed();
    }

    public final int getGreen() {
        return this.color.getGreen();
    }

    public final int getBlue() {
        return this.color.getBlue();
    }

    public final int getAlpha() {
        return this.color.getAlpha();
    }

    @NotNull
    public final String getHex() {
        return Integer.toHexString(this.color.getRGB());
    }

    public final float getHue() {
        return this.hsb[0];
    }

    public final float getSaturation() {
        return this.hsb[1];
    }

    public final float getBrightness() {
        return this.hsb[2];
    }

    public final void addListener(@NotNull ColorListener listener2) {
        this.addListener(listener2, true);
    }

    public final void addListener(@NotNull ColorListener listener2, boolean invokeOnEveryColorChange) {
        this.listeners.add(listener2);
        if (invokeOnEveryColorChange) {
            this.instantListeners.add(listener2);
        }
    }

    public final void removeListener(@NotNull ColorListener listener2) {
        this.listeners.remove(listener2);
        this.instantListeners.remove(listener2);
    }

    public ColorPickerModel(@NotNull Color originalColor) {
        boolean bl = false;
        this.listeners = new LinkedHashSet();
        bl = false;
        this.instantListeners = new LinkedHashSet();
        this.color = originalColor;
        this.hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
    }

    public /* synthetic */ ColorPickerModel(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = ColorPickerModelKt.getDEFAULT_PICKER_COLOR();
        }
        this(color);
    }

    public ColorPickerModel() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Set access$getListeners$p(ColorPickerModel $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ Color access$getColor$p(ColorPickerModel $this) {
        return $this.color;
    }

    public static final /* synthetic */ void access$setColor$p(ColorPickerModel $this, Color color) {
        $this.color = color;
    }
}

