/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithAutoCompletionListProvider<T>
extends DefaultTextCompletionValueDescriptor<T>
implements TextCompletionProvider {
    private static final Logger LOG = Logger.getInstance(TextFieldWithAutoCompletionListProvider.class);
    @NotNull
    protected Collection<T> myVariants;
    @Nullable
    private String myCompletionAdvertisement;

    protected TextFieldWithAutoCompletionListProvider(@Nullable Collection<T> variants) {
        this.setItems(variants);
        this.myCompletionAdvertisement = null;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text, int offset) {
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text, offset);
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
        if (prefixMatcher != null) {
            return result2.withPrefixMatcher(prefixMatcher);
        }
        return result2;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        Collection<T> items = this.getItems(prefix, true, parameters2);
        TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, items, -10000);
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator mainIndicator = progressManager.getProgressIndicator();
        SensitiveProgressWrapper indicator = mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new EmptyProgressIndicator();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> (Collection)progressManager.runProcess(() -> this.getItems(prefix, false, parameters2), indicator));
        while (true) {
            try {
                Collection tasks = (Collection)future2.get(100L, TimeUnit.MILLISECONDS);
                if (tasks != null) {
                    TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, tasks, 0);
                    return;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static <T> void addCompletionElements(CompletionResultSet result2, TextCompletionValueDescriptor<T> descriptor2, Collection<? extends T> items, int index) {
        AutoCompletionPolicy completionPolicy = ApplicationManager.getApplication().isUnitTestMode() ? AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE : AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        int grouping = index;
        for (T item : items) {
            if (item == null) {
                LOG.error("Null item from " + descriptor2);
                continue;
            }
            LookupElementBuilder builder2 = descriptor2.createLookupBuilder(item);
            result2.addElement(PrioritizedLookupElement.withGrouping((LookupElement)builder2.withAutoCompletionPolicy(completionPolicy), (int)grouping--));
        }
    }

    public void setItems(@Nullable Collection<T> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    @NotNull
    public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters2) {
        if (prefix == null) {
            return Collections.emptyList();
        }
        ArrayList<T> items = new ArrayList<T>(this.myVariants);
        items.sort(this);
        return items;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        if (this.myCompletionAdvertisement != null) {
            return this.myCompletionAdvertisement;
        }
        String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickJavaDoc");
        String advertisementTail = this.getQuickDocHotKeyAdvertisementTail(shortcut);
        if (advertisementTail == null) {
            return null;
        }
        return "Pressing " + shortcut + " would show " + advertisementTail;
    }

    @Nullable
    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        return null;
    }

    public void setAdvertisement(@Nullable String completionAdvertisement) {
        this.myCompletionAdvertisement = completionAdvertisement;
    }

    @Nullable
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    public static String getCompletionPrefix(CompletionParameters parameters2) {
        String text = parameters2.getOriginalFile().getText();
        int offset = parameters2.getOffset();
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text, offset);
    }

    @NotNull
    private static String getCompletionPrefix(String text, int offset) {
        int i2 = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        return text.substring(Math.max(i2, j), offset);
    }
}

