/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Cell;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TableSpeedSearch
extends SpeedSearchBase<JTable> {
    private static final PairFunction<Object, Cell, String> TO_STRING = (o, cell) -> o == null || o instanceof Boolean ? "" : o.toString();
    private final PairFunction<Object, ? super Cell, String> myToStringConvertor;

    public TableSpeedSearch(JTable table) {
        this(table, TO_STRING);
    }

    public TableSpeedSearch(JTable table, Convertor<Object, String> toStringConvertor) {
        this(table, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    public TableSpeedSearch(JTable table, PairFunction<Object, ? super Cell, String> toStringConvertor) {
        super(table);
        this.myToStringConvertor = toStringConvertor;
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        new MySelectAllAction(table, this).registerCustomShortcutSet(table, null);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        boolean tableIsNotEmpty = ((JTable)this.myComponent).getRowCount() != 0 && ((JTable)this.myComponent).getColumnCount() != 0;
        return tableIsNotEmpty && !((JTable)this.myComponent).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    @NotNull
    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new MyListIterator(startingIndex);
    }

    @Override
    protected int getElementCount() {
        return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        if (element2 instanceof Integer) {
            int index = (Integer)element2;
            int row = index / ((JTable)this.myComponent).getColumnCount();
            int col = index % ((JTable)this.myComponent).getColumnCount();
            ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row, row);
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
        } else {
            ((JTable)this.myComponent).getSelectionModel().clearSelection();
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        int row = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row > -1 && col > -1 ? row * ((JTable)this.myComponent).getColumnCount() + col : -1;
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected String getElementText(Object element2) {
        int index = (Integer)element2;
        int row = index / ((JTable)this.myComponent).getColumnCount();
        int col = index % ((JTable)this.myComponent).getColumnCount();
        Object value2 = ((JTable)this.myComponent).getValueAt(row, col);
        return (String)this.myToStringConvertor.fun(value2, (Object)new Cell(row, col));
    }

    @NotNull
    private TIntArrayList findAllFilteredRows(String s) {
        TIntArrayList rows = new TIntArrayList();
        String _s = s.trim();
        block0: for (int row = 0; row < ((JTable)this.myComponent).getRowCount(); ++row) {
            for (int col = 0; col < ((JTable)this.myComponent).getColumnCount(); ++col) {
                int index = row * ((JTable)this.myComponent).getColumnCount() + col;
                if (!this.isMatchingElement(index, _s)) continue;
                rows.add(row);
                continue block0;
            }
        }
        return rows;
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableSpeedSearch mySearch;

        MySelectAllAction(@NotNull JTable table, @NotNull TableSpeedSearch search2) {
            this.myTable = table;
            this.mySearch = search2;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTable.getRowSelectionAllowed() && this.myTable.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ListSelectionModel sm = this.myTable.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered2 = this.mySearch.findAllFilteredRows(query);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered2.toNativeArray(), this.myTable.getSelectedRows());
            if (alreadySelected) {
                int anchor2 = sm.getAnchorSelectionIndex();
                sm.setSelectionInterval(anchor2, anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement instanceof Integer) {
                    int index = (Integer)currentElement;
                    anchor3 = index / this.myTable.getColumnCount();
                }
                if (anchor3 == -1) {
                    anchor3 = filtered2.get(0);
                }
                sm.clearSelection();
                for (int i2 = 0; i2 < filtered2.size(); ++i2) {
                    int value2 = filtered2.get(i2);
                    sm.addSelectionInterval(value2, value2);
                }
                sm.setAnchorSelectionIndex(anchor3);
            }
        }
    }

    private class MyListIterator
    implements ListIterator<Object> {
        private int myCursor;

        MyListIterator(int startingIndex) {
            int total = TableSpeedSearch.this.getElementCount();
            this.myCursor = startingIndex < 0 ? total : startingIndex;
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < TableSpeedSearch.this.getElementCount();
        }

        @Override
        public Object next() {
            return this.myCursor++;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public Object previous() {
            return this.myCursor-- - 1;
        }

        @Override
        public int nextIndex() {
            return this.myCursor;
        }

        @Override
        public int previousIndex() {
            return this.myCursor - 1;
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void set(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void add(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }
    }
}

