/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemTrayNotifications
implements SystemNotificationsImpl.Notifier {
    private static SystemTrayNotifications ourWin10Instance;
    private final TrayIcon myTrayIcon;
    private final TrayIcon.MessageType myType;

    @Nullable
    static synchronized SystemTrayNotifications getWin10Instance() throws AWTException {
        if (ourWin10Instance == null && SystemTray.isSupported()) {
            ourWin10Instance = new SystemTrayNotifications(SystemTrayNotifications.createImage(), TrayIcon.MessageType.INFO);
        }
        return ourWin10Instance;
    }

    @NotNull
    private static Image createImage() {
        Icon icon2 = AppUIUtil.loadSmallApplicationIcon(ScaleContext.create());
        return ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)icon2));
    }

    private SystemTrayNotifications(@NotNull Image image, @NotNull TrayIcon.MessageType type) throws AWTException {
        this.myType = type;
        String tooltip = ApplicationInfoImpl.getShadowInstance().getFullApplicationName();
        this.myTrayIcon = new TrayIcon(image, tooltip);
        this.myTrayIcon.setImageAutoSize(true);
        SystemTray.getSystemTray().add(this.myTrayIcon);
        this.myTrayIcon.addActionListener(e -> {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame instanceof Window) {
                UIUtil.toFront((Window)((Window)frame));
            }
        });
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title, @NotNull String description) {
        this.myTrayIcon.displayMessage(title, description, this.myType);
    }
}

