/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<? super T, String> myToStringConvertor;

    public ListSpeedSearch(@NotNull JList<T> list2) {
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(@NotNull JList<T> list2, @NotNull Function<? super T, String> convertor) {
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    private void registerSelectAll(@NotNull JList<T> list2) {
        new MySelectAllAction<T>(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        if (element2 != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element2);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        return ListSpeedSearch.getAllListElements((JList)this.myComponent);
    }

    public static <T> Object[] getAllListElements(@NotNull JList<T> list2) {
        ListModel<T> model = list2.getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements2 = new Object[model.getSize()];
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            elements2[i2] = model.getElementAt(i2);
        }
        return elements2;
    }

    @Override
    protected String getElementText(Object element2) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element2);
        }
        return element2 == null ? null : element2.toString();
    }

    @NotNull
    private TIntArrayList findAllFilteredElements(@NotNull String s) {
        TIntArrayList indices = new TIntArrayList();
        String _s = s.trim();
        Object[] elements2 = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            Object element2 = elements2[i2];
            if (!this.isMatchingElement(element2, _s)) continue;
            indices.add(i2);
        }
        return indices;
    }

    private static final class MySelectAllAction<T>
    extends DumbAwareAction {
        @NotNull
        private final JList<T> myList;
        @NotNull
        private final ListSpeedSearch<T> mySearch;

        MySelectAllAction(@NotNull JList<T> list2, @NotNull ListSpeedSearch<T> search2) {
            this.myList = list2;
            this.mySearch = search2;
            AnAction action2 = ActionManager.getInstance().getAction("$SelectAll");
            if (action2 != null) {
                this.copyShortcutFrom(action2);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered2 = ((ListSpeedSearch)this.mySearch).findAllFilteredElements(query);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered2.toNativeArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor2 = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    List<Object> elements2 = Arrays.asList(ListSpeedSearch.getAllListElements(this.myList));
                    anchor3 = ContainerUtil.indexOfIdentity(elements2, (Object)currentElement);
                }
                if (anchor3 == -1) {
                    anchor3 = filtered2.get(0);
                }
                this.myList.setSelectedIndices(filtered2.toNativeArray());
                sm.setAnchorSelectionIndex(anchor3);
            }
        }
    }
}

