/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicensingFacade {
    public String licensedTo;
    public List<String> restrictions;
    public boolean isEvaluation;
    public Date expirationDate;
    public Date perpetualFallbackDate;
    public Map<String, Date> expirationDates;
    public Map<String, String> confirmationStamps;
    public String metadata;
    public static volatile LicensingFacade INSTANCE;

    @Nullable
    public static LicensingFacade getInstance() {
        return INSTANCE;
    }

    @Nullable
    public String getLicensedToMessage() {
        return this.licensedTo;
    }

    @NotNull
    public List<String> getLicenseRestrictionsMessages() {
        return this.restrictions == null ? Collections.emptyList() : Collections.unmodifiableList(this.restrictions);
    }

    public boolean isEvaluationLicense() {
        return this.isEvaluation;
    }

    public boolean isApplicableForProduct(@NotNull Date releaseDate) {
        return this.isPerpetualForProduct(releaseDate) || this.expirationDate == null || releaseDate.before(this.expirationDate);
    }

    public boolean isPerpetualForProduct(@NotNull Date releaseDate) {
        return this.perpetualFallbackDate != null && releaseDate.before(this.perpetualFallbackDate);
    }

    @Nullable
    public Date getLicenseExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public Date getExpirationDate(String productCode) {
        return this.expirationDates == null ? null : this.expirationDates.get(productCode);
    }

    @Nullable
    public String getConfirmationStamp(String productCode) {
        return this.confirmationStamps == null ? null : this.confirmationStamps.get(productCode);
    }

    public boolean isEA2Product(@NotNull String productCodeOrPluginId) {
        return ArrayUtil.contains((String)productCodeOrPluginId, (String[])new String[]{"DPN", "DC", "DPA", "PDB", "PWS", "PGO", "PPS", "PPC", "PRB", "PSW", "Pythonid"});
    }
}

