/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsPaneImpl
implements TabbedPane {
    private final JBEditorTabsBase myTabs;
    private final CopyOnWriteArraySet<ChangeListener> myListeners = new CopyOnWriteArraySet();

    public JBTabsPaneImpl(@Nullable Project project, int tabPlacement, @NotNull Disposable parent) {
        this.myTabs = JBTabsFactory.createEditorTabs((Project)project, (Disposable)parent);
        this.myTabs.getPresentation().setAlphabeticalMode(false).setSupportsCompression(false).setFirstTabOffset(10);
        this.myTabs.setEmptySpaceColorCallback(() -> UIUtil.getBgFillColor((Component)this.myTabs.getComponent().getParent()));
        this.myTabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                JBTabsPaneImpl.this.fireChanged(new ChangeEvent(JBTabsPaneImpl.this.myTabs));
            }
        }).getPresentation().setPaintBorder(1, 1, 1, 1).setTabSidePaintBorder(2).setPaintFocus(StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        this.setTabPlacement(tabPlacement);
    }

    private void fireChanged(ChangeEvent event) {
        for (ChangeListener each : this.myListeners) {
            each.stateChanged(event);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.myTabs.getComponent();
    }

    @Override
    public void putClientProperty(@NotNull Object key, Object value2) {
        this.myTabs.getComponent().putClientProperty(key, value2);
    }

    @Override
    public void setKeyboardNavigation(@NotNull PrevNextActionsDescriptor installKeyboardNavigation) {
        this.myTabs.setNavigationActionBinding(installKeyboardNavigation.getPrevActionId(), installKeyboardNavigation.getNextActionId());
    }

    @Override
    public void addChangeListener(@NotNull ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    @Override
    public void insertTab(@NotNull String title, Icon icon2, @NotNull Component c, String tip, int index) {
        assert (c instanceof JComponent);
        this.myTabs.addTab(new TabInfo((JComponent)c).setText(title).setTooltipText(tip).setIcon(icon2), index);
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        JBTabsPresentation presentation2 = this.myTabs.getPresentation();
        switch (tabPlacement) {
            case 1: {
                presentation2.setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                presentation2.setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                presentation2.setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                presentation2.setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tab placement code=" + tabPlacement);
            }
        }
    }

    @Override
    public void addMouseListener(@NotNull MouseListener listener2) {
        this.myTabs.getComponent().addMouseListener(listener2);
    }

    @Override
    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    @Override
    public Component getSelectedComponent() {
        TabInfo selected2 = this.myTabs.getSelectedInfo();
        return selected2 != null ? selected2.getComponent() : null;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.myTabs.select(this.getTabAt(index), false);
    }

    @Override
    public Component getTabComponentAt(int index) {
        TabInfo tabInfo = this.myTabs.getTabAt(index);
        return this.myTabs.getTabLabel(tabInfo);
    }

    @Override
    public void removeTabAt(int index) {
        this.myTabs.removeTab(this.getTabAt(index));
    }

    private TabInfo getTabAt(int index) {
        this.checkIndex(index);
        return this.myTabs.getTabAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index);
        }
    }

    @Override
    public void revalidate() {
        this.myTabs.getComponent().revalidate();
    }

    @Override
    public Color getForegroundAt(int index) {
        return this.getTabAt(index).getDefaultForeground();
    }

    @Override
    public void setForegroundAt(int index, Color color) {
        this.getTabAt(index).setDefaultForeground(color);
    }

    @Override
    public Component getComponentAt(int i2) {
        return this.getTabAt(i2).getComponent();
    }

    @Override
    public void setTitleAt(int index, @NotNull String title) {
        this.getTabAt(index).setText(title);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        this.getTabAt(index).setTooltipText(toolTipText);
    }

    @Override
    public void setComponentAt(int index, Component c) {
        this.getTabAt(index).setComponent(c);
    }

    @Override
    public void setIconAt(int index, Icon icon2) {
        this.getTabAt(index).setIcon(icon2);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        this.getTabAt(index).setEnabled(enabled);
    }

    @Override
    public int getTabLayoutPolicy() {
        return this.myTabs.getPresentation().isSingleRow() ? 1 : 0;
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    @Override
    public void scrollTabToVisible(int index) {
    }

    @Override
    public String getTitleAt(int i2) {
        return this.getTabAt(i2).getText();
    }

    @Override
    public void removeAll() {
        this.myTabs.removeAllTabs();
    }

    @Override
    public void updateUI() {
        this.myTabs.getComponent().updateUI();
    }

    @Override
    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public JBTabs getTabs() {
        return this.myTabs;
    }
}

