/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ProjectTopics;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorNotificationsImpl
extends EditorNotifications {
    public static final ProjectExtensionPointName<EditorNotifications.Provider<?>> EP_PROJECT = new ProjectExtensionPointName("com.intellij.editorNotificationProvider");
    private static final Key<Boolean> PENDING_UPDATE = Key.create((String)"pending.notification.update");
    private final MergingUpdateQueue myUpdateMerger;
    @NotNull
    private final Project myProject;

    public EditorNotificationsImpl(@NotNull Project project) {
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project).usePassThroughInUnitTestMode();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                EditorNotificationsImpl.this.updateNotifications(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                VirtualFile file2 = event.getNewFile();
                FileEditor editor = event.getNewEditor();
                if (file2 != null && editor != null && Boolean.TRUE.equals(editor.getUserData(PENDING_UPDATE))) {
                    editor.putUserData(PENDING_UPDATE, null);
                    EditorNotificationsImpl.this.updateEditors(file2, Collections.singletonList(editor));
                }
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
        EP_PROJECT.getPoint((AreaInstance)project).addExtensionPointListener(new ExtensionPointListener<EditorNotifications.Provider<?>>(){

            public void extensionAdded(@NotNull EditorNotifications.Provider extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void extensionRemoved(@NotNull EditorNotifications.Provider extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorNotificationsImpl.this.updateNotifications(extension);
            }
        }, false, (Disposable)project);
    }

    public void updateNotifications(@NotNull EditorNotifications.Provider<?> provider) {
        Key key = provider.getKey();
        for (VirtualFile file2 : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
            List<FileEditor> editors = this.getEditors(file2);
            for (FileEditor editor : editors) {
                this.updateNotification(editor, (Key<? extends JComponent>)key, null, PluginInfoDetectorKt.getPluginInfo(provider.getClass()));
            }
        }
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            List<FileEditor> editors = this.getEditors(file2);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Iterator<FileEditor> it = editors.iterator();
                while (it.hasNext()) {
                    FileEditor e = it.next();
                    if (e.getComponent().isShowing()) continue;
                    e.putUserData(PENDING_UPDATE, (Object)Boolean.TRUE);
                    it.remove();
                }
            }
            if (!editors.isEmpty()) {
                this.updateEditors(file2, editors);
            }
        });
    }

    @NotNull
    private List<FileEditor> getEditors(@NotNull VirtualFile file2) {
        return ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor -> !(editor instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor).getEditor()));
    }

    private void updateEditors(@NotNull VirtualFile file2, List<FileEditor> editors) {
        ReadAction.nonBlocking(() -> this.calcNotificationUpdates(file2, editors)).expireWith((Disposable)this.myProject).expireWhen(() -> !file2.isValid()).coalesceBy(new Object[]{this, file2}).finishOnUiThread(ModalityState.any(), updates -> {
            for (Runnable update2 : updates) {
                update2.run();
            }
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @NotNull
    private List<Runnable> calcNotificationUpdates(@NotNull VirtualFile file2, @NotNull List<? extends FileEditor> editors) {
        List providers = DumbService.getDumbAwareExtensions((Project)this.myProject, EP_PROJECT);
        SmartList updates = null;
        for (FileEditor fileEditor : editors) {
            for (EditorNotifications.Provider provider : providers) {
                if (this.myProject.isDisposed()) {
                    return Collections.emptyList();
                }
                JComponent component2 = provider.createNotificationPanel(file2, fileEditor, this.myProject);
                if (component2 instanceof EditorNotificationPanel) {
                    ((EditorNotificationPanel)component2).setProviderKey(provider.getKey());
                    ((EditorNotificationPanel)component2).setProject(this.myProject);
                }
                if (updates == null) {
                    updates = new SmartList();
                }
                updates.add(() -> this.updateNotification(editor, (Key<? extends JComponent>)provider.getKey(), component2, PluginInfoDetectorKt.getPluginInfo(provider.getClass())));
            }
        }
        return updates == null ? Collections.emptyList() : updates;
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component2, PluginInfo pluginInfo) {
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component2 != null) {
            FeatureUsageData data2 = new FeatureUsageData().addData("key", key.toString()).addPluginInfo(pluginInfo);
            FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "shown", data2);
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component2);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component2);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void logNotificationActionInvocation(@Nullable Key<?> providerKey, @Nullable Class<?> runnableClass) {
        if (providerKey == null || runnableClass == null) {
            return;
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("key", providerKey.toString()).addData("class_name", runnableClass.getName()).addPluginInfo(PluginInfoDetectorKt.getPluginInfo(runnableClass));
        FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "actionInvoked", data2);
    }

    public void updateAllNotifications() {
        if (this.myProject.isDefault()) {
            throw new UnsupportedOperationException("Editor notifications aren't supported for default project");
        }
        final FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        if (fileEditorManager == null) {
            throw new IllegalStateException("No FileEditorManager for " + this.myProject);
        }
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : fileEditorManager.getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }

    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    public static class RefactoringListenerProvider
    implements RefactoringElementListenerProvider {
        @Nullable
        public RefactoringElementListener getListener(final @NotNull PsiElement element2) {
            if (element2 instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile vFile;
                        if (newElement instanceof PsiFile && (vFile = newElement.getContainingFile().getVirtualFile()) != null) {
                            EditorNotifications.getInstance((Project)element2.getProject()).updateNotifications(vFile);
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        this.elementRenamedOrMoved(newElement);
                    }
                };
            }
            return null;
        }
    }
}

