/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ColorLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final ColorLineMarkerProvider INSTANCE = new ColorLineMarkerProvider();

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        return (LineMarkerInfo)ElementColorProvider.EP_NAME.computeSafeIfAny(provider -> {
            Color color = provider.getColorFrom(element2);
            if (color == null) {
                return null;
            }
            MyInfo info = new MyInfo(element2, color, (ElementColorProvider)provider);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Choose color", null, (Icon)AllIcons.Actions.Colors);
            return info;
        });
    }

    public String getName() {
        return CodeInsightBundle.message((String)"gutter.color.preview", (Object[])new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Gutter.Colors;
    }

    private static class MyInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Color myColor;

        MyInfo(@NotNull PsiElement element2, Color color, ElementColorProvider colorProvider) {
            super(element2, element2.getTextRange(), (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, color)), (Function)FunctionUtil.nullConstant(), (e, elt) -> {
                if (!elt.isWritable()) {
                    return;
                }
                Editor editor = PsiEditorUtil.findEditor((PsiElement)elt);
                assert (editor != null);
                if (Registry.is((String)"ide.new.color.picker")) {
                    RelativePoint relativePoint = new RelativePoint(e.getComponent(), e.getPoint());
                    ColorPicker.showColorPickerPopup(element2.getProject(), color, (c, l) -> WriteAction.run(() -> colorProvider.setColorTo(elt, c)), relativePoint, true);
                } else {
                    Color c2 = ColorChooser.chooseColor((Project)editor.getProject(), (Component)editor.getComponent(), (String)IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), (Color)color, (boolean)true);
                    if (c2 != null) {
                        WriteAction.run(() -> colorProvider.setColorTo(elt, c2));
                    }
                }
            }, GutterIconRenderer.Alignment.LEFT);
            this.myColor = color;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            return info instanceof MyInfo;
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            return JBUI.scale((JBUI.JBIcon)new ColorsIcon(12, (Color[])infos.stream().map(_info -> ((MyInfo)_info).myColor).toArray(Color[]::new)));
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            return FunctionUtil.nullConstant();
        }
    }
}

