/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

public final class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static List<Image> ourIcons = null;
    private static volatile boolean ourMacDocIconSet = false;
    private static final int MIN_ICON_SIZE = 32;

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(AppUIUtil.class);
    }

    public static void updateWindowIcon(@NotNull Window window) {
        if (AppUIUtil.isWindowIconAlreadyExternallySet()) {
            return;
        }
        List<Image> images = ourIcons;
        if (images == null) {
            String fallback;
            ourIcons = images = new ArrayList<Image>(3);
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            String svgIconUrl = appInfo.getApplicationSvgIconUrl();
            String smallSvgIconUrl = appInfo.getSmallApplicationSvgIconUrl();
            ScaleContext ctx = ScaleContext.create((Component)window);
            if (SystemInfo.isUnix) {
                fallback = appInfo.getBigIconUrl();
                ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadApplicationIconImage(svgIconUrl, ctx, 128, fallback));
            }
            fallback = appInfo.getIconUrl();
            ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadApplicationIconImage(smallSvgIconUrl, ctx, 32, fallback));
            if (SystemInfo.isWindows) {
                ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadSmallApplicationIconImage(ctx, 16));
            }
            for (int i2 = 0; i2 < images.size(); ++i2) {
                Image image = images.get(i2);
                if (!(image instanceof JBHiDPIScaledImage)) continue;
                images.set(i2, ((JBHiDPIScaledImage)image).getDelegate());
            }
        }
        if (!images.isEmpty()) {
            if (!SystemInfoRt.isMac) {
                window.setIconImages(images);
            } else if (!ourMacDocIconSet && (PlatformUtils.isIntelliJClient() || PluginManagerCore.isRunningFromSources())) {
                AppIcon.MacAppIcon.setDockIcon(ImageUtil.toBufferedImage((Image)images.get(0)));
                ourMacDocIconSet = true;
            }
        }
    }

    public static boolean isWindowIconAlreadyExternallySet() {
        if (SystemInfoRt.isMac) {
            return ourMacDocIconSet || !PlatformUtils.isIntelliJClient() && !PluginManagerCore.isRunningFromSources();
        }
        return SystemInfoRt.isWindows && Boolean.getBoolean("ide.native.launcher") && Boolean.getBoolean("jbre.win.app.icon.supported");
    }

    @NotNull
    private static Image loadSmallApplicationIconImage(@NotNull ScaleContext ctx, int size) {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String fallbackSmallIconUrl = appInfo.getSmallIconUrl();
        return AppUIUtil.loadApplicationIconImage(appInfo.getSmallApplicationSvgIconUrl(), ctx, size, fallbackSmallIconUrl);
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext ctx) {
        return AppUIUtil.loadSmallApplicationIcon(ctx, 16);
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext ctx, int size) {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String smallIconUrl = appInfo.getSmallApplicationSvgIconUrl();
        Icon icon2 = AppUIUtil.loadApplicationIcon(smallIconUrl, ctx, size);
        if (icon2 != null) {
            return icon2;
        }
        String fallbackSmallIconUrl = appInfo.getSmallIconUrl();
        Image image = ImageLoader.loadFromResource((String)fallbackSmallIconUrl);
        icon2 = new JBImageIcon(image);
        AppUIUtil.scaleIconToSize(icon2, size);
        return icon2;
    }

    @Nullable
    public static Icon loadApplicationIcon(@NotNull ScaleContext ctx, int size) {
        String url = ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl();
        return AppUIUtil.loadApplicationIcon(url, ctx, size);
    }

    @Contract(value="_, _, _, !null -> !null")
    @Nullable
    private static Image loadApplicationIconImage(String svgPath, ScaleContext ctx, int size, String fallbackPath) {
        Icon icon2 = AppUIUtil.loadApplicationIcon(svgPath, ctx, size);
        if (icon2 != null) {
            return IconUtil.toImage((Icon)icon2, (ScaleContext)ctx);
        }
        if (fallbackPath != null) {
            return ImageLoader.loadFromResource((String)fallbackPath);
        }
        return null;
    }

    @Nullable
    private static Icon loadApplicationIcon(String svgPath, ScaleContext ctx, int size) {
        if (svgPath == null) {
            return null;
        }
        Icon icon2 = IconLoader.findIcon((String)svgPath);
        if (icon2 == null) {
            AppUIUtil.getLogger().info("Cannot load SVG application icon from " + svgPath);
            return null;
        }
        if (icon2 instanceof ScaleContextSupport) {
            ((ScaleContextSupport)icon2).updateScaleContext((UserScaleContext)ctx);
        }
        return AppUIUtil.scaleIconToSize(icon2, size);
    }

    @NotNull
    private static Icon scaleIconToSize(Icon icon2, int size) {
        int width = icon2.getIconWidth();
        if (width == size) {
            return icon2;
        }
        float scale = (float)size / (float)width;
        icon2 = IconUtil.scale((Icon)icon2, null, (float)scale);
        return icon2;
    }

    public static void invokeLaterIfProjectAlive(@NotNull Project project, @NotNull Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, o -> !project.isOpen() || project.isDisposed());
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    @Deprecated
    public static void invokeOnEdt(@NotNull Runnable runnable2, @Nullable Condition<?> expired) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass(@NotNull Toolkit toolkit) {
        if (SystemInfoRt.isWindows || SystemInfoRt.isMac) {
            return;
        }
        try {
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFrameClass() {
        String wmClass;
        String name = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getFullProductNameWithEdition()).replace(' ', '-').replace("intellij-idea", "idea").replace("android-studio", "studio").replace("-community-edition", "-ce").replace("-ultimate-edition", "").replace("-professional-edition", "");
        String string = wmClass = name.startsWith(VENDOR_PREFIX) ? name : VENDOR_PREFIX + name;
        if (PluginManagerCore.isRunningFromSources()) {
            wmClass = wmClass + "-debug";
        }
        return wmClass;
    }

    public static void hideToolWindowBalloon(@NotNull String id2, @NotNull Project project) {
        AppUIUtil.invokeLaterIfProjectAlive(project, () -> {
            Balloon balloon = ToolWindowManager.getInstance((Project)project).getToolWindowBalloon(id2);
            if (balloon != null) {
                balloon.hide();
            }
        });
    }

    @Nullable
    public static String findIcon() {
        URL url;
        String[] childFiles;
        String iconsPath = PathManager.getBinPath();
        for (String child2 : childFiles = (String[])ObjectUtils.notNull((Object)new File(iconsPath).list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)) {
            if (!child2.endsWith(".svg")) continue;
            return iconsPath + '/' + child2;
        }
        String svgIconUrl = ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl();
        if (svgIconUrl != null && (url = ApplicationInfoEx.class.getResource(svgIconUrl)) != null && "file".equals(url.getProtocol())) {
            return URLUtil.urlToFile((URL)url).getAbsolutePath();
        }
        int best = 31;
        String iconPath = null;
        for (String child3 : childFiles) {
            String path;
            ImageIcon icon2;
            int size;
            if (!child3.endsWith(".png") || (size = (icon2 = new ImageIcon(path = iconsPath + '/' + child3)).getIconHeight()) <= best || size != icon2.getIconWidth()) continue;
            best = size;
            iconPath = path;
        }
        return iconPath;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean showConsentsAgreementIfNeed(@NotNull Logger log) {
        return AppUIUtil.showConsentsAgreementIfNeeded(log);
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Logger log) {
        return AppUIUtil.showConsentsAgreementIfNeeded((Runnable command) -> {
            if (EventQueue.isDispatchThread()) {
                command.run();
            } else {
                try {
                    EventQueue.invokeAndWait(command);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    log.warn((Throwable)e);
                }
            }
        });
    }

    public static boolean needToShowConsentsAgreement() {
        return (Boolean)ConsentOptions.getInstance().getConsents().second;
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Executor edtExecutor2) {
        Pair<List<Consent>, Boolean> consentsToShow = ConsentOptions.getInstance().getConsents();
        Ref result2 = new Ref((Object)Boolean.FALSE);
        if (((Boolean)consentsToShow.second).booleanValue()) {
            edtExecutor2.execute(() -> result2.set((Object)AppUIUtil.confirmConsentOptions((List)consentsToShow.first)));
        }
        return (Boolean)result2.get();
    }

    public static void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    public static boolean confirmConsentOptions(final @NotNull List<Consent> consents) {
        List<Consent> result2;
        if (consents.isEmpty()) {
            return false;
        }
        final ConsentSettingsUi ui = new ConsentSettingsUi(false);
        DialogWrapper dialog2 = new DialogWrapper(true){

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                JComponent southPanel = super.createSouthPanel();
                if (southPanel != null) {
                    southPanel.setBorder(1.createDefaultBorder());
                }
                return southPanel;
            }

            protected JComponent createCenterPanel() {
                return ui.getComponent();
            }

            protected Action @NotNull [] createActions() {
                if (consents.size() > 1) {
                    Action[] actions = super.createActions();
                    this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                    this.setCancelButtonText(IdeBundle.message((String)"button.skip", (Object[])new Object[0]));
                    return actions;
                }
                this.setOKButtonText(((Consent)consents.iterator().next()).getName());
                return new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"button.don.t.send", (Object[])new Object[0])){

                    protected void doAction(ActionEvent e) {
                        this.close(2);
                    }
                }};
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setAutoAdjustable(false);
            }
        };
        ui.reset(consents);
        dialog2.setModal(true);
        dialog2.setTitle(IdeBundle.message((String)"dialog.title.data.sharing", (Object[])new Object[0]));
        dialog2.pack();
        if (consents.size() < 2) {
            dialog2.setSize(dialog2.getWindow().getWidth(), dialog2.getWindow().getHeight() + JBUIScale.scale((int)75));
        }
        dialog2.show();
        int exitCode = dialog2.getExitCode();
        if (exitCode == 1) {
            return false;
        }
        if (consents.size() == 1) {
            result2 = Collections.singletonList(consents.iterator().next().derive(exitCode == 0));
        } else {
            result2 = new ArrayList<Consent>();
            ui.apply(result2);
        }
        AppUIUtil.saveConsents(result2);
        return true;
    }

    public static List<Consent> loadConsentsForEditing() {
        Consent statConsent;
        ConsentOptions options2 = ConsentOptions.getInstance();
        ArrayList<Consent> result2 = (ArrayList<Consent>)options2.getConsents().first;
        if (options2.isEAP() && (statConsent = options2.getUsageStatsConsent()) != null) {
            ArrayList<Consent> consents = result2;
            result2 = new ArrayList<Consent>();
            result2.add(statConsent.derive(UsageStatisticsPersistenceComponent.getInstance().isAllowed()));
            result2.addAll(consents);
        }
        return result2;
    }

    public static void saveConsents(List<Consent> consents) {
        Consent defaultStatsConsent;
        ConsentOptions options2 = ConsentOptions.getInstance();
        Application app = ApplicationManager.getApplication();
        List<Consent> toSave = consents;
        if (app != null && options2.isEAP() && (defaultStatsConsent = options2.getUsageStatsConsent()) != null) {
            toSave = new ArrayList<Consent>();
            for (Consent consent : consents) {
                if (defaultStatsConsent.getId().equals(consent.getId())) {
                    UsageStatisticsPersistenceComponent.getInstance().setAllowed(consent.isAccepted());
                    continue;
                }
                toSave.add(consent);
            }
        }
        if (!toSave.isEmpty()) {
            options2.setConsents(toSave);
        }
    }

    public static void targetToDevice(@NotNull Component comp, @Nullable Component target2) {
        if (comp.isShowing()) {
            return;
        }
        GraphicsConfiguration gc = target2 != null ? target2.getGraphicsConfiguration() : null;
        AppUIUtil.setGraphicsConfiguration(comp, gc);
    }

    public static void setGraphicsConfiguration(@NotNull Component comp, @Nullable GraphicsConfiguration gc) {
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
    }

    public static boolean isInFullscreen(@Nullable Window window) {
        return window instanceof IdeFrame && ((IdeFrame)window).isInFullScreen();
    }
}

