/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class TerminalConsoleContentHelper
implements Disposable {
    private static final int FLUSH_TIMEOUT = 200;
    private final Collection<ObservableConsoleView.ChangeListener> myChangeListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
    private final Set<ConsoleViewContentType> myContentTypes = ContainerUtil.newConcurrentSet();
    private final Alarm myAlarm;
    private final AtomicBoolean myRequested = new AtomicBoolean(false);
    private volatile boolean myDisposed = false;

    TerminalConsoleContentHelper(@NotNull TerminalExecutionConsole console) {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Disposer.register((Disposable)console, (Disposable)this);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        this.myChangeListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> this.myChangeListeners.remove(listener2));
    }

    public void onContentTypePrinted(@NotNull ConsoleViewContentType contentType) {
        this.myContentTypes.add(contentType);
        if (this.myRequested.compareAndSet(false, true) && !this.myDisposed) {
            this.myAlarm.addRequest(this::flush, 200);
        }
    }

    private void flush() {
        if (this.myDisposed) {
            return;
        }
        this.myRequested.set(false);
        ArrayList<ConsoleViewContentType> contentTypes = new ArrayList<ConsoleViewContentType>(this.myContentTypes);
        this.myContentTypes.removeAll(contentTypes);
        if (!contentTypes.isEmpty()) {
            this.fireContentAdded(contentTypes);
        }
    }

    private void fireContentAdded(@NotNull List<ConsoleViewContentType> contentTypes) {
        for (ObservableConsoleView.ChangeListener listener2 : this.myChangeListeners) {
            listener2.contentAdded(contentTypes);
        }
    }

    public void dispose() {
        this.myDisposed = true;
        this.myAlarm.cancelAllRequests();
    }
}

