/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class PendingTasksRunner {
    private final List<Runnable> myPendingTasks = new ArrayList<Runnable>();
    private final AtomicBoolean myReady = new AtomicBoolean(false);
    private final Alarm myAlarm;

    PendingTasksRunner(long awaitTimeout, @NotNull Project project) {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myAlarm.addRequest(() -> this.setReady(), awaitTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull Runnable task2) {
        if (this.myReady.get()) {
            task2.run();
        } else {
            List<Runnable> list2 = this.myPendingTasks;
            synchronized (list2) {
                this.myPendingTasks.add(task2);
            }
            if (this.myReady.get()) {
                this.runPendingTasks();
            }
        }
    }

    public void setReady() {
        if (this.myReady.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)this.myAlarm);
            this.runPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        ArrayList<Runnable> tasks;
        List<Runnable> list2 = this.myPendingTasks;
        synchronized (list2) {
            tasks = new ArrayList<Runnable>(this.myPendingTasks);
            this.myPendingTasks.clear();
        }
        for (Runnable task2 : tasks) {
            task2.run();
        }
    }
}

