/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class XDebuggerBreakpointsContextProvider
extends WorkingContextProvider {
    XDebuggerBreakpointsContextProvider() {
    }

    @NotNull
    public String getId() {
        return "xDebugger";
    }

    @NotNull
    public String getDescription() {
        return "XDebugger breakpoints";
    }

    public void saveContext(@NotNull Project project, @NotNull Element toElement) throws WriteExternalException {
        BreakpointManagerState state = new BreakpointManagerState();
        XDebuggerBreakpointsContextProvider.getBreakpointManager(XDebuggerManager.getInstance((Project)project)).saveState(state);
        Element serialize = XmlSerializer.serialize((Object)((Object)state));
        if (serialize != null) {
            toElement.addContent((Collection)serialize.removeContent());
        }
    }

    @NotNull
    private static XBreakpointManagerImpl getBreakpointManager(XDebuggerManager instance) {
        return (XBreakpointManagerImpl)instance.getBreakpointManager();
    }

    public void loadContext(@NotNull Project project, @NotNull Element fromElement) throws InvalidDataException {
        XDebuggerBreakpointsContextProvider.getBreakpointManager(XDebuggerManager.getInstance((Project)project)).loadState((BreakpointManagerState)((Object)XmlSerializer.deserialize((Element)fromElement, BreakpointManagerState.class)));
    }

    public void clearContext(@NotNull Project project) {
        XBreakpointBase<?, ?, ?>[] breakpoints;
        XBreakpointManagerImpl breakpointManager = XDebuggerBreakpointsContextProvider.getBreakpointManager(XDebuggerManager.getInstance((Project)project));
        for (XBreakpointBase<?, ?, ?> breakpoint : breakpoints = breakpointManager.getAllBreakpoints()) {
            ApplicationManager.getApplication().runWriteAction(() -> breakpointManager.removeBreakpoint(breakpoint));
        }
    }
}

