/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OpenEditorsContextProvider
extends WorkingContextProvider {
    OpenEditorsContextProvider() {
    }

    @Nullable
    private static FileEditorManagerImpl getFileEditorManager(@NotNull Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        return fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
    }

    @NotNull
    public String getId() {
        return "editors";
    }

    @NotNull
    public String getDescription() {
        return "Open editors and positions";
    }

    public void saveContext(@NotNull Project project, @NotNull Element element2) {
        FileEditorManagerImpl fileEditorManager = OpenEditorsContextProvider.getFileEditorManager(project);
        if (fileEditorManager != null) {
            fileEditorManager.getMainSplitters().writeExternal(element2);
        }
        element2.addContent(((DockManagerImpl)DockManager.getInstance((Project)project)).getState());
    }

    public void loadContext(@NotNull Project project, @NotNull Element element2) {
        Element dockState;
        FileEditorManagerImpl fileEditorManager = OpenEditorsContextProvider.getFileEditorManager(project);
        if (fileEditorManager != null) {
            fileEditorManager.loadState(element2);
            fileEditorManager.getMainSplitters().openFiles();
        }
        if ((dockState = element2.getChild("DockManager")) != null) {
            DockManagerImpl dockManager = (DockManagerImpl)DockManager.getInstance((Project)project);
            dockManager.loadState(dockState);
            dockManager.readState();
        }
    }

    public void clearContext(@NotNull Project project) {
        FileEditorManagerImpl fileEditorManager = OpenEditorsContextProvider.getFileEditorManager(project);
        if (fileEditorManager != null) {
            fileEditorManager.closeAllFiles();
            fileEditorManager.getMainSplitters().clear();
        }
        DockManagerImpl dockManager = (DockManagerImpl)DockManager.getInstance((Project)project);
        for (DockContainer container2 : dockManager.getContainers()) {
            if (!(container2 instanceof DockableEditorTabbedContainer)) continue;
            container2.closeAll();
        }
    }
}

