/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.ProjectTaskState;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.task.impl.ProjectTaskManagerListener;
import com.intellij.task.impl.ProjectTaskScope;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private static final Logger LOG = Logger.getInstance(ProjectTaskManager.class);
    private final ProjectTaskRunner myDummyTaskRunner = new DummyTaskRunner();
    private final ProjectTaskListener myEventPublisher;
    private final List<ProjectTaskManagerListener> myListeners = new CopyOnWriteArrayList<ProjectTaskManagerListener>();

    public ProjectTaskManagerImpl(@NotNull Project project) {
        super(project);
        this.myEventPublisher = (ProjectTaskListener)project.getMessageBus().syncPublisher(ProjectTaskListener.TOPIC);
    }

    public Promise<ProjectTaskManager.Result> build(Module @NotNull [] modules2) {
        return this.run(this.createModulesBuildTask(modules2, true, true, false));
    }

    public Promise<ProjectTaskManager.Result> rebuild(Module @NotNull [] modules2) {
        return this.run(this.createModulesBuildTask(modules2, false, false, false));
    }

    public Promise<ProjectTaskManager.Result> compile(VirtualFile @NotNull [] files2) {
        List buildTasks = ContainerUtil.map(Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet(), entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue()));
        return this.run(new ProjectTaskList(buildTasks));
    }

    public Promise<ProjectTaskManager.Result> build(ProjectModelBuildableElement @NotNull [] buildableElements) {
        return this.doBuild(buildableElements, true);
    }

    public Promise<ProjectTaskManager.Result> rebuild(ProjectModelBuildableElement @NotNull [] buildableElements) {
        return this.doBuild(buildableElements, false);
    }

    public Promise<ProjectTaskManager.Result> buildAllModules() {
        return this.run(this.createAllModulesBuildTask(true, this.myProject));
    }

    public Promise<ProjectTaskManager.Result> rebuildAllModules() {
        return this.run(this.createAllModulesBuildTask(false, this.myProject));
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules2.length == 1 ? new ModuleBuildTaskImpl(modules2[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(modules2), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTask projectTask) {
        return this.run(new ProjectTaskContext(), projectTask);
    }

    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask) {
        AsyncPromise promiseResult = new AsyncPromise();
        SmartList toRun = new SmartList();
        Consumer<Collection> taskClassifier = arg_0 -> this.lambda$run$6((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), taskClassifier);
        context.putUserData(ProjectTaskScope.KEY, (Object)new ProjectTaskScope((List)toRun){
            final /* synthetic */ List val$toRun;
            {
                this.val$toRun = list2;
            }

            @Override
            @NotNull
            public <T extends ProjectTask> List<T> getRequestedTasks(@NotNull Class<T> instanceOf) {
                ArrayList tasks = new ArrayList();
                this.val$toRun.forEach(pair -> ((Collection)pair.second).stream().filter(instanceOf::isInstance).map(task2 -> task2).forEach(tasks::add));
                return tasks;
            }
        });
        IdeActivity activity = new IdeActivity(this.myProject, "build").startedWithData(arg_0 -> ProjectTaskManagerImpl.lambda$run$8((List)toRun, arg_0));
        this.myEventPublisher.started(context);
        Runnable runnable2 = () -> this.lambda$run$13(context, promiseResult, activity, (List)toRun);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        } else {
            runnable2.run();
        }
        return promiseResult;
    }

    @ApiStatus.Experimental
    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        while (true) {
            try {
                return (T)promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private static Supplier<List<String>> moduleOutputPathsProvider(@NotNull Module module) {
        return () -> (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().getClassesRoots()).filterMap(file2 -> file2.isDirectory() && !file2.getFileSystem().isReadOnly() ? file2.getPath() : null).toList());
    }

    public final void addListener(@NotNull ProjectTaskManagerListener listener2) {
        this.myListeners.add(listener2);
    }

    private static void sendSuccessEmptyResult(@NotNull ProjectTaskContext context, @NotNull Consumer<ProjectTaskManager.Result> resultConsumer) {
        resultConsumer.accept(new MyResult(context, Collections.emptyMap(), false, false));
    }

    private static void sendAbortedEmptyResult(@NotNull ProjectTaskContext context, @NotNull Consumer<ProjectTaskManager.Result> resultConsumer) {
        resultConsumer.accept(new MyResult(context, Collections.emptyMap(), true, false));
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer) {
        if (tasks.isEmpty()) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            Object taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : ContainerUtil.emptyList());
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.accept(tasks);
    }

    private Promise<ProjectTaskManager.Result> doBuild(ProjectModelBuildableElement @NotNull [] buildableElements, boolean isIncrementalBuild) {
        return this.run(this.createBuildTask(isIncrementalBuild, buildableElements));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.run(projectTask), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.run(context, projectTask), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void buildAllModules(@Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.buildAllModules(), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void rebuildAllModules(@Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.rebuildAllModules(), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void build(Module @NotNull [] modules2, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.build(modules2), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void rebuild(Module @NotNull [] modules2, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.rebuild(modules2), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void compile(VirtualFile @NotNull [] files2, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.compile(files2), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void build(ProjectModelBuildableElement @NotNull [] buildableElements, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.build(buildableElements), callback2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void rebuild(ProjectModelBuildableElement @NotNull [] buildableElements, @Nullable ProjectTaskNotification callback2) {
        ProjectTaskManagerImpl.assertUnsupportedOperation(callback2);
        ProjectTaskManagerImpl.notifyIfNeeded(this.rebuild(buildableElements), callback2);
    }

    private static void notifyIfNeeded(@NotNull Promise<ProjectTaskManager.Result> promise, @Nullable ProjectTaskNotification callback2) {
        if (callback2 != null) {
            promise.onSuccess(result2 -> callback2.finished(result2.getContext(), new ProjectTaskResult(result2.isAborted(), result2.hasErrors() ? 1 : 0, 0))).onError(throwable -> callback2.finished(new ProjectTaskContext(), new ProjectTaskResult(true, 0, 0)));
        }
    }

    private static void assertUnsupportedOperation(@Nullable ProjectTaskNotification callback2) {
        if (callback2 instanceof ProjectTaskNotificationAdapter) {
            throw new UnsupportedOperationException("Please, provide implementation for non-deprecated methods");
        }
    }

    private /* synthetic */ void lambda$run$13(ProjectTaskContext context, AsyncPromise promiseResult, IdeActivity activity, List toRun) {
        for (ProjectTaskManagerListener listener2 : this.myListeners) {
            try {
                listener2.beforeRun(context);
            }
            catch (com.intellij.execution.ExecutionException e) {
                ProjectTaskManagerImpl.sendAbortedEmptyResult(context, new ResultConsumer(promiseResult));
                activity.finished();
                return;
            }
        }
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessEmptyResult(context, new ResultConsumer(promiseResult));
            activity.finished();
            return;
        }
        ProjectTaskResultsAggregator resultsCollector = new ProjectTaskResultsAggregator(context, new ResultConsumer(promiseResult), toRun.size(), activity);
        for (Pair pair : toRun) {
            Consumer<ProjectTaskRunner.Result> runnerResultConsumer = result2 -> resultsCollector.add((ProjectTaskRunner.Result)result2, (Collection)pair.second);
            if (((Collection)pair.second).isEmpty()) {
                runnerResultConsumer.accept((ProjectTaskRunner.Result)TaskRunnerResults.SUCCESS);
                continue;
            }
            ProjectTaskRunner runner = (ProjectTaskRunner)pair.first;
            if (context.isCollectionOfGeneratedFilesEnabled() && !runner.isFileGeneratedEventsSupported()) {
                ((Collection)pair.second).stream().filter(ModuleBuildTask.class::isInstance).map(task2 -> ((ModuleBuildTask)task2).getModule()).forEach(module -> context.addDirtyOutputPathsProvider(ProjectTaskManagerImpl.moduleOutputPathsProvider(module)));
            }
            runner.run(this.myProject, context, ((Collection)pair.second).toArray(EMPTY_TASKS_ARRAY)).onSuccess(runnerResultConsumer).onError(throwable -> runnerResultConsumer.accept((ProjectTaskRunner.Result)TaskRunnerResults.ABORTED));
        }
    }

    private static /* synthetic */ void lambda$run$8(List toRun, FeatureUsageData data2) {
        data2.addData("task_runner_class", ContainerUtil.map((Collection)toRun, it -> ((ProjectTaskRunner)it.first).getClass().getName()));
    }

    private /* synthetic */ void lambda$run$6(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream(ProjectTaskRunner.EP_NAME.getExtensions()).filter(runner -> {
            try {
                return runner.canRun(this.myProject, aTask);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Broken project task runner: " + runner.getClass().getName(), (Throwable)e);
                return false;
            }
        }).findFirst().orElse(this.myDummyTaskRunner)));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }

    private static class ProjectTaskNotificationAdapter
    implements ProjectTaskNotification {
        private final AsyncPromise<ProjectTaskManager.Result> myPromise;
        private final ProjectTaskContext myContext;

        private ProjectTaskNotificationAdapter(@NotNull AsyncPromise<ProjectTaskManager.Result> promise, @NotNull ProjectTaskContext context) {
            this.myPromise = promise;
            this.myContext = context;
        }

        public void finished(final @NotNull ProjectTaskResult executionResult) {
            this.myPromise.setResult((Object)new ProjectTaskManager.Result(){

                @NotNull
                public ProjectTaskContext getContext() {
                    return myContext;
                }

                public boolean isAborted() {
                    return executionResult.isAborted();
                }

                public boolean hasErrors() {
                    return executionResult.getErrors() > 0;
                }

                public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate) {
                    return executionResult.anyMatch(predicate);
                }
            });
        }
    }

    private static class ResultWrapper
    implements ProjectTaskManager.Result {
        private final ProjectTaskManager.Result myResult;

        private ResultWrapper(ProjectTaskManager.Result result2) {
            this.myResult = result2;
        }

        @NotNull
        public ProjectTaskContext getContext() {
            return this.myResult.getContext();
        }

        public boolean isAborted() {
            return this.myResult.isAborted();
        }

        public boolean hasErrors() {
            return this.myResult.hasErrors();
        }

        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate) {
            return this.myResult.anyTaskMatches(predicate);
        }
    }

    private static class MyResult
    implements ProjectTaskManager.Result {
        private final ProjectTaskContext myContext;
        private final boolean myAborted;
        private final boolean myErrors;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private MyResult(@NotNull ProjectTaskContext context, @NotNull Map<ProjectTask, ProjectTaskState> tasksState, boolean isAborted, boolean hasErrors) {
            this.myContext = context;
            this.myTasksState = tasksState;
            this.myAborted = isAborted;
            this.myErrors = hasErrors;
        }

        @NotNull
        public ProjectTaskContext getContext() {
            return this.myContext;
        }

        public boolean isAborted() {
            return this.myAborted;
        }

        public boolean hasErrors() {
            return this.myErrors;
        }

        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate) {
            return this.myTasksState.entrySet().stream().anyMatch(entry -> predicate.test((ProjectTask)entry.getKey(), (ProjectTaskState)entry.getValue()));
        }
    }

    private static class ProjectTaskResultsAggregator {
        private final ProjectTaskContext myContext;
        private final ResultConsumer myResultConsumer;
        private final AtomicInteger myProgressCounter;
        private final IdeActivity myActivity;
        private final AtomicBoolean myErrorsFlag;
        private final AtomicBoolean myAbortedFlag;
        private final Map<ProjectTask, ProjectTaskState> myTasksState = new ConcurrentHashMap<ProjectTask, ProjectTaskState>();

        private ProjectTaskResultsAggregator(@NotNull ProjectTaskContext context, @NotNull ResultConsumer resultConsumer, int expectedResults, @NotNull IdeActivity activity) {
            this.myContext = context;
            this.myResultConsumer = resultConsumer;
            this.myProgressCounter = new AtomicInteger(expectedResults);
            this.myActivity = activity;
            this.myErrorsFlag = new AtomicBoolean(false);
            this.myAbortedFlag = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(final @NotNull ProjectTaskRunner.Result result2, @NotNull Collection<? extends ProjectTask> tasks) {
            int inProgress = this.myProgressCounter.decrementAndGet();
            ProjectTaskState state = new ProjectTaskState(){

                public boolean isSkipped() {
                    return result2.isAborted();
                }

                public boolean isFailed() {
                    return result2.hasErrors();
                }
            };
            for (ProjectTask projectTask : tasks) {
                this.myTasksState.put(projectTask, state);
            }
            if (result2.isAborted()) {
                this.myAbortedFlag.set(true);
            }
            if (result2.hasErrors()) {
                this.myErrorsFlag.set(true);
            }
            if (inProgress <= 0) {
                try {
                    this.myResultConsumer.accept(new MyResult(this.myContext, this.myTasksState, this.myAbortedFlag.get(), this.myErrorsFlag.get()));
                }
                finally {
                    this.myActivity.finished();
                }
            }
        }
    }

    private class ResultConsumer
    implements Consumer<ProjectTaskManager.Result> {
        @NotNull
        private final AsyncPromise<ProjectTaskManager.Result> myPromise;

        private ResultConsumer(AsyncPromise<ProjectTaskManager.Result> promise) {
            this.myPromise = promise;
        }

        @Override
        public void accept(@NotNull ProjectTaskManager.Result result2) {
            if (!result2.isAborted() && !result2.hasErrors()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        for (ProjectTaskManagerListener listener2 : ProjectTaskManagerImpl.this.myListeners) {
                            listener2.afterRun(result2);
                        }
                        this.notify(result2);
                    }
                    catch (com.intellij.execution.ExecutionException e) {
                        LOG.debug((Throwable)e);
                        this.notify(new ResultWrapper(result2){

                            @Override
                            public boolean hasErrors() {
                                return true;
                            }
                        });
                    }
                });
            } else {
                this.notify(result2);
            }
        }

        private void notify(@NotNull ProjectTaskManager.Result result2) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!ProjectTaskManagerImpl.this.myProject.isDisposed()) {
                    ProjectTaskManagerImpl.this.myEventPublisher.finished(result2);
                }
                this.myPromise.setResult((Object)result2);
            }, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
            return Promises.resolvedPromise((Object)TaskRunnerResults.SUCCESS);
        }

        public boolean canRun(@NotNull ProjectTask projectTask) {
            return true;
        }
    }
}

