/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.usages.UsageViewSettings;
import com.intellij.util.SystemProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SliceToTextFileExporter
implements ExporterToTextFile {
    private final SliceTreeBuilder myBuilder;
    @NotNull
    private final UsageViewSettings myUsageViewSettings;
    private final String myLineSeparator = SystemProperties.getLineSeparator();

    public SliceToTextFileExporter(@NotNull SliceTreeBuilder builder2, @NotNull UsageViewSettings usageViewSettings) {
        this.myBuilder = builder2;
        this.myUsageViewSettings = usageViewSettings;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buffer = new StringBuilder();
        this.appendChildren(buffer, this.myBuilder.getRootSliceNode(), "");
        return buffer.toString();
    }

    private void appendNode(StringBuilder buffer, SliceNode node, String indent) {
        buffer.append(indent).append(node.getNodeText()).append(this.myLineSeparator);
        this.appendChildren(buffer, node, indent + "    ");
    }

    private void appendChildren(StringBuilder buffer, SliceNode node, String indent) {
        List<SliceNode> cachedChildren = node.getCachedChildren();
        if (cachedChildren != null) {
            for (SliceNode child2 : cachedChildren) {
                this.appendNode(buffer, child2, indent);
            }
        } else {
            buffer.append(indent).append("...").append(this.myLineSeparator);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        return this.myUsageViewSettings.getExportFileName();
    }

    public void exportedTo(@NotNull String filePath) {
        this.myUsageViewSettings.setExportFileName(filePath);
    }

    public boolean canExport() {
        return !this.myBuilder.analysisInProgress;
    }
}

