/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import org.jetbrains.annotations.NotNull;

public final class CloudRunConfigurationUtil {
    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(RemoteServer<SC> account, Module module, DC deploymentConfiguration) {
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        ModuleDeploymentSourceImpl deploymentSource = new ModuleDeploymentSourceImpl(modulePointer);
        return CloudRunConfigurationUtil.createRunConfiguration(account, module, (DeploymentSource)deploymentSource, deploymentConfiguration);
    }

    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(@NotNull RemoteServer<SC> account, @NotNull Module module, @NotNull DeploymentSource deploymentSource, DC deploymentConfiguration) {
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        String name = CloudRunConfigurationUtil.generateRunConfigurationName(account, module);
        ConfigurationFactory configurationFactory = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(account.getType()).getFactoryForType(deploymentSource.getType());
        RunnerAndConfigurationSettings runSettings = runManager.createConfiguration(name, configurationFactory);
        DeployToServerRunConfiguration result2 = (DeployToServerRunConfiguration)runSettings.getConfiguration();
        result2.setServerName(account.getName());
        result2.setDeploymentSource(deploymentSource);
        result2.setDeploymentConfiguration(deploymentConfiguration);
        RunManagerImplKt.callNewConfigurationCreated(configurationFactory, runSettings.getConfiguration());
        runManager.addConfiguration(runSettings);
        runManager.setSelectedConfiguration(runSettings);
        return result2;
    }

    private static String generateRunConfigurationName(@NotNull RemoteServer<?> account, Module module) {
        String accountName = account.getName();
        String moduleName = module.getName();
        return CloudBundle.message((String)"run.configuration.name", (Object[])new Object[]{accountName, moduleName});
    }
}

