/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ApplicationActionUtils {
    private ApplicationActionUtils() {
    }

    @Nullable
    public static DeploymentNode getDeploymentTarget(@NotNull AnActionEvent e) {
        return (DeploymentNode)ServiceViewActionUtils.getTarget((AnActionEvent)e, DeploymentNode.class);
    }

    @Nullable
    public static Deployment getDeployment(@Nullable DeploymentNode node) {
        return node == null ? null : (Deployment)ObjectUtils.tryCast((Object)node.getValue(), Deployment.class);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T> T getApplicationRuntime(@Nullable DeploymentNode node, @NotNull Class<T> clazz) {
        Deployment deployment = ApplicationActionUtils.getDeployment(node);
        return (T)(deployment == null ? null : ObjectUtils.tryCast((Object)deployment.getRuntime(), clazz));
    }

    @Nullable
    public static <T> T getApplicationRuntime(@NotNull AnActionEvent e, @NotNull Class<T> clazz) {
        Deployment deployment = ApplicationActionUtils.getDeployment(ApplicationActionUtils.getDeploymentTarget(e));
        return (T)(deployment == null ? null : ObjectUtils.tryCast((Object)deployment.getRuntime(), clazz));
    }

    @NotNull
    public static Runnable createLogSelector(@NotNull Project project, @NotNull ServersTreeNodeSelector selector, @NotNull DeploymentNode node, @NotNull String logName) {
        SelectLogRunnable selectLogRunnable = new SelectLogRunnable(project, selector, node, logName);
        DisposableSelectLogRunnableWrapper wrapper2 = new DisposableSelectLogRunnableWrapper(selectLogRunnable);
        Disposer.register((Disposable)project, (Disposable)wrapper2);
        return wrapper2;
    }

    private static class SelectLogRunnable
    implements Runnable {
        private final Project myProject;
        private final ServersTreeNodeSelector mySelector;
        private final DeploymentNode myNode;
        private final String myLogName;

        SelectLogRunnable(@NotNull Project project, @NotNull ServersTreeNodeSelector selector, @NotNull DeploymentNode node, @NotNull String logName) {
            this.myProject = project;
            this.mySelector = selector;
            this.myNode = node;
            this.myLogName = logName;
        }

        @Override
        public void run() {
            RemoteServer server = (RemoteServer)this.myNode.getServerNode().getValue();
            ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
            if (connection == null) {
                return;
            }
            Deployment deployment = this.findDeployment(connection);
            if (deployment == null) {
                return;
            }
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> this.mySelector.select(connection, deployment.getName(), this.myLogName));
        }

        private Deployment findDeployment(ServerConnection<?> connection) {
            DeploymentRuntime applicationRuntime = ApplicationActionUtils.getApplicationRuntime(this.myNode, DeploymentRuntime.class);
            for (Deployment deployment : connection.getDeployments()) {
                if (applicationRuntime != deployment.getRuntime()) continue;
                return deployment;
            }
            return null;
        }
    }

    private static class DisposableSelectLogRunnableWrapper
    implements Runnable,
    Disposable {
        private volatile Runnable mySelectLogRunnable;

        private DisposableSelectLogRunnableWrapper(Runnable selectLogRunnable) {
            this.mySelectLogRunnable = selectLogRunnable;
        }

        public void dispose() {
            this.mySelectLogRunnable = null;
        }

        @Override
        public void run() {
            Runnable selectLogRunnable = this.mySelectLogRunnable;
            if (selectLogRunnable != null) {
                selectLogRunnable.run();
                Disposer.dispose((Disposable)this);
            }
        }
    }
}

