/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowMessagePanel;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.util.Alarm;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteServersDeploymentManager {
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Project myProject;
    private final ServersTreeNodeSelector myNodeSelector;
    private final Map<RemoteServersServiceViewContributor, Boolean> myContributors = CollectionFactory.createConcurrentWeakMap();
    private final Map<RemoteServer<?>, MessagePanel> myServerToContent = new HashMap();

    public static RemoteServersDeploymentManager getInstance(Project project) {
        return (RemoteServersDeploymentManager)ServiceManager.getService((Project)project, RemoteServersDeploymentManager.class);
    }

    public RemoteServersDeploymentManager(@NotNull Project project) {
        this.myProject = project;
        this.myNodeSelector = new ServersTreeNodeSelectorImpl(project);
        this.initListeners();
        RemoteServersView.getInstance(project).registerTreeNodeSelector(this.myNodeSelector, connection -> this.myContributors.keySet().stream().anyMatch(contributor -> contributor.accept(connection.getServer())));
    }

    private void initListeners() {
        this.myProject.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){
            private final Set<ServerConnection<?>> myConnectionsToExpand = new HashSet();

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.this.findContributor(connection.getServer());
                if (contributor != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                RemoteServer server = connection.getServer();
                RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.this.findContributor(server);
                if (contributor != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                    RemoteServersDeploymentManager.updateServerContent((MessagePanel)RemoteServersDeploymentManager.this.myServerToContent.get(server), connection);
                    if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                        this.myConnectionsToExpand.add(connection);
                        RemoteServersDeploymentManager.pollDeployments(connection);
                    } else {
                        this.myConnectionsToExpand.remove(connection);
                    }
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                RemoteServer server = connection.getServer();
                RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.this.findContributor(server);
                if (contributor != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                    RemoteServersDeploymentManager.updateServerContent((MessagePanel)RemoteServersDeploymentManager.this.myServerToContent.get(server), connection);
                    if (this.myConnectionsToExpand.remove(connection)) {
                        ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(RemoteServersDeploymentManager.this.myProject, connection.getServer(), contributor);
                        ServiceViewManager.getInstance((Project)RemoteServersDeploymentManager.this.myProject).expand((Object)serverNode, contributor.getClass());
                    }
                }
            }
        });
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.this.findContributor(server);
                if (contributor != null) {
                    RemoteServersDeploymentManager.this.myServerToContent.put(server, RemoteServersDeploymentManager.createMessagePanel());
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.this.findContributor(server);
                if (contributor != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
                RemoteServersDeploymentManager.this.myServerToContent.remove(server);
            }
        });
    }

    public void registerContributor(@NotNull RemoteServersServiceViewContributor contributor) {
        if (this.myContributors.put(contributor, Boolean.TRUE) == null) {
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> {
                for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                    if (!contributor.accept(server)) continue;
                    this.myServerToContent.put(server, RemoteServersDeploymentManager.createMessagePanel());
                }
            });
        }
    }

    @NotNull
    public ServersTreeNodeSelector getNodeSelector() {
        return this.myNodeSelector;
    }

    public JComponent getServerContent(RemoteServer<?> server) {
        MessagePanel messagePanel = this.myServerToContent.get(server);
        if (messagePanel == null) {
            return null;
        }
        RemoteServersDeploymentManager.updateServerContent(messagePanel, ServerConnectionManager.getInstance().getConnection(server));
        return messagePanel.getComponent();
    }

    private static void updateServerContent(@Nullable MessagePanel messagePanel, @Nullable ServerConnection<?> connection) {
        if (messagePanel == null) {
            return;
        }
        if (connection == null) {
            messagePanel.setEmptyText(CloudBundle.message((String)"cloud.status.double.click.to.connect", (Object[])new Object[0]));
        } else {
            String text = connection.getStatusText();
            if (text.contains("<br/>") && !text.startsWith("<html>")) {
                text = "<html><center>" + text + "</center></html>";
            }
            messagePanel.setEmptyText(text);
        }
    }

    @Nullable
    private RemoteServersServiceViewContributor findContributor(@NotNull RemoteServer<?> server) {
        for (RemoteServersServiceViewContributor contributor : this.myContributors.keySet()) {
            if (!contributor.accept(server)) continue;
            return contributor;
        }
        return null;
    }

    private static void pollDeployments(@NotNull ServerConnection<?> connection) {
        connection.computeDeployments(() -> new Alarm().addRequest(() -> {
            if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                RemoteServersDeploymentManager.pollDeployments(connection);
            }
        }, 2000, ModalityState.any()));
    }

    @Nullable
    public static ServersTreeNodeSelector getNodeSelector(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return RemoteServersDeploymentManager.getInstance(project).getNodeSelector();
    }

    public static MessagePanel createMessagePanel() {
        return new ServersToolWindowMessagePanel();
    }

    private static class ServersTreeNodeSelectorImpl
    implements ServersTreeNodeSelector {
        private final Project myProject;

        ServersTreeNodeSelectorImpl(Project project) {
            this.myProject = project;
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection) {
            RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer());
            if (contributor == null) {
                return;
            }
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), contributor);
            ServiceViewManager.getInstance((Project)this.myProject).select((Object)serverNode, contributor.getClass(), true, true);
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
            RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer());
            if (contributor == null) {
                return;
            }
            AbstractTreeNode<?> deploymentNode = this.findDeployment(contributor, connection, deploymentName);
            if (deploymentNode != null) {
                ServiceViewManager.getInstance((Project)this.myProject).select(deploymentNode, contributor.getClass(), true, false);
            }
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName, @NotNull String logName) {
            RemoteServersServiceViewContributor contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer());
            if (contributor == null) {
                return;
            }
            AbstractTreeNode<?> deploymentNode = this.findDeployment(contributor, connection, deploymentName);
            if (deploymentNode != null) {
                contributor.selectLog(deploymentNode, logName);
            }
        }

        private AbstractTreeNode<?> findDeployment(RemoteServersServiceViewContributor contributor, ServerConnection<?> connection, String deploymentName) {
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), contributor);
            RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor serverContributor = contributor.createNodeContributor(serverNode);
            ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, (Object)serverContributor, contributor.getClass()));
            for (Deployment deployment : connection.getDeployments()) {
                if (!deployment.getName().equals(deploymentName)) continue;
                return contributor.createDeploymentNode(connection, serverNode, deployment);
            }
            return null;
        }
    }

    public static interface MessagePanel {
        public void setEmptyText(@NotNull String var1);

        @NotNull
        public JComponent getComponent();
    }
}

