/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImpl<D extends DeploymentConfiguration>
implements Deployment {
    private final ServerConnectionImpl<D> myConnection;
    private final String myName;
    private final DeploymentTask<D> myDeploymentTask;
    private volatile DeploymentState myState;
    private String myPresentableName;

    public DeploymentImpl(@NotNull ServerConnectionImpl<D> connection, @NotNull String name, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @Nullable DeploymentTask<D> deploymentTask) {
        this.myConnection = connection;
        this.myName = name;
        this.myDeploymentTask = deploymentTask;
        this.myState = new DeploymentState(status, statusText, runtime);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public DeploymentStatus getStatus() {
        return this.myState.getStatus();
    }

    @NotNull
    public String getStatusText() {
        String statusText = this.myState.getStatusText();
        return statusText != null ? statusText : this.myState.getStatus().getPresentableText();
    }

    public DeploymentRuntime getRuntime() {
        return this.myState.getRuntime();
    }

    @Nullable
    public DeploymentTask<D> getDeploymentTask() {
        return this.myDeploymentTask;
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project) {
        return this.myConnection.getOrCreateLogManager(project, this);
    }

    public void disposeAllLogs() {
        this.myConnection.disposeAllLogs(this);
    }

    public void setStatus(@NotNull DeploymentStatus status, @Nullable String statusText) {
        this.myConnection.changeDeploymentState(this, this.getRuntime(), this.myState.getStatus(), status, statusText);
    }

    @NotNull
    public ServerConnection<?> getConnection() {
        return this.myConnection;
    }

    @Nullable
    public DeploymentRuntime getParentRuntime() {
        DeploymentRuntime runtime = this.getRuntime();
        return runtime == null ? null : runtime.getParent();
    }

    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (this.myState.getStatus() == oldStatus) {
            this.myState = new DeploymentState(newStatus, statusText, runtime);
            return true;
        }
        return false;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName == null ? this.getName() : this.myPresentableName;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    protected static class DeploymentState {
        private final DeploymentStatus myStatus;
        private final String myStatusText;
        private final DeploymentRuntime myRuntime;

        private DeploymentState(@NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
            this.myStatus = status;
            this.myStatusText = statusText;
            this.myRuntime = runtime;
        }

        @NotNull
        public DeploymentStatus getStatus() {
            return this.myStatus;
        }

        @Nullable
        public String getStatusText() {
            return this.myStatusText;
        }

        @Nullable
        public DeploymentRuntime getRuntime() {
            return this.myRuntime;
        }
    }
}

