/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerConfigurationTypesRegistrar
implements ApplicationInitializedListener {
    public void componentsInitialized() {
        DeployToServerConfigurationTypesRegistrar.getConfigurationTypesExtPoint().registerExtensions(ContainerUtil.map((Collection)ServerType.EP_NAME.getExtensionList(), type -> new DeployToServerConfigurationType((ServerType<?>)type)));
        ServerType.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ServerType>(){

            public void extensionAdded(@NotNull ServerType addedServer, @NotNull PluginDescriptor pluginDescriptor) {
                DeployToServerConfigurationTypesRegistrar.getConfigurationTypesExtPoint().registerExtension((Object)new DeployToServerConfigurationType(addedServer));
            }

            public void extensionRemoved(@NotNull ServerType removedServer, @NotNull PluginDescriptor pluginDescriptor) {
                DeployToServerConfigurationType deployForServer = DeployToServerConfigurationTypesRegistrar.findDeployConfigurationType(removedServer);
                if (deployForServer != null) {
                    DeployToServerConfigurationTypesRegistrar.getConfigurationTypesExtPoint().unregisterExtension((Object)deployForServer);
                }
            }
        }, null);
    }

    @NotNull
    public static DeployToServerConfigurationType getDeployConfigurationType(@NotNull ServerType<?> serverType) {
        DeployToServerConfigurationType result2 = DeployToServerConfigurationTypesRegistrar.findDeployConfigurationType(serverType);
        if (result2 == null) {
            throw new IllegalArgumentException("Cannot find run configuration type for " + serverType.getClass());
        }
        return result2;
    }

    @Nullable
    private static DeployToServerConfigurationType findDeployConfigurationType(@NotNull ServerType<?> serverType) {
        return (DeployToServerConfigurationType)((Object)ConfigurationType.CONFIGURATION_TYPE_EP.findFirstSafe(next -> DeployToServerConfigurationTypesRegistrar.isDeployForServerType(next, serverType)));
    }

    private static ExtensionPointImpl<ConfigurationType> getConfigurationTypesExtPoint() {
        return (ExtensionPointImpl)ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
    }

    private static boolean isDeployForServerType(@NotNull ConfigurationType configurationType, @NotNull ServerType<?> serverType) {
        return configurationType instanceof DeployToServerConfigurationType && ((DeployToServerConfigurationType)configurationType).isForServerType(serverType);
    }
}

