/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteServerListConfigurableProvider
extends ConfigurableProvider {
    public boolean canCreateConfigurable() {
        List<ServerType<?>> serverTypes = RemoteServerListConfigurableProvider.getServerTypesIncludedInList();
        return !serverTypes.isEmpty();
    }

    public Configurable createConfigurable() {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), RemoteServerListConfigurableProvider.getServerTypesIncludedInList(), null);
    }

    @NotNull
    private static List<ServerType<?>> getServerTypesIncludedInList() {
        return ContainerUtil.map((Collection)IncludeServerType.EP_NAME.getExtensionList(), BaseKeyedLazyInstance::getInstance);
    }

    public static class IncludeServerType
    extends BaseKeyedLazyInstance<ServerType<?>> {
        public static final ExtensionPointName<IncludeServerType> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.defaultConfigurable.includeServerType");
        @Attribute(value="serverType")
        public String myServerType;

        @Nullable
        protected String getImplementationClassName() {
            return this.myServerType;
        }
    }
}

