/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.agent.RemoteAgent;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.remoteServer.agent.impl.RemoteAgentReflectiveThreadProxyFactory;
import com.intellij.util.Base64;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoteAgentManagerImpl
extends RemoteAgentManager {
    private final RemoteAgentClassLoaderCache myClassLoaderCache = new RemoteAgentClassLoaderCache();

    public <T extends RemoteAgent> T createAgent(RemoteAgentProxyFactory agentProxyFactory, List<File> instanceLibraries, List<Class<?>> commonJarClasses, String specificsRuntimeModuleName, String specificsBuildJarPath, Class<T> agentInterface, String agentClassName, Class<?> pluginClass) throws Exception {
        RemoteAgentManager.Builder builder2 = this.createAgentBuilder(agentProxyFactory, agentInterface, pluginClass).withRtDependencies(commonJarClasses).withInstanceLibraries(instanceLibraries).withModuleDependency(specificsRuntimeModuleName, specificsBuildJarPath);
        return (T)builder2.buildAgent(agentClassName);
    }

    public <T extends RemoteAgent> RemoteAgentManager.Builder<T> createAgentBuilder(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
        return new AgentBuilderImpl<T>(agentProxyFactory, agentInterface, pluginClass);
    }

    public RemoteAgentProxyFactory createReflectiveThreadProxyFactory(ClassLoader callerClassLoader) {
        return new RemoteAgentReflectiveThreadProxyFactory(this.myClassLoaderCache, callerClassLoader);
    }

    private static class AgentBuilderImpl<T extends RemoteAgent>
    extends RemoteAgentManager.Builder<T> {
        private final List<Class<?>> myRtClasses = new ArrayList();
        private final List<File> myInstanceLibraries = new ArrayList<File>();
        private final List<File> myModuleDependencies = new ArrayList<File>();
        private final RemoteAgentProxyFactory myAgentProxyFactory;
        private final Class<T> myAgentInterface;
        private final String myAllPluginsRoot;
        private final boolean myRunningFromSources;

        AgentBuilderImpl(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
            this.myAgentProxyFactory = agentProxyFactory;
            this.myAgentInterface = agentInterface;
            File plugin = new File(PathUtil.getJarPathForClass(pluginClass));
            this.myAllPluginsRoot = plugin.getParent();
            this.myRunningFromSources = plugin.isDirectory();
        }

        public T buildAgent(@NotNull String agentClassName) throws Exception {
            List<File> libraries = this.listLibraryFiles();
            return (T)((RemoteAgent)this.myAgentProxyFactory.createProxy(libraries, this.myAgentInterface, agentClassName));
        }

        @NotNull
        private List<File> listLibraryFiles() {
            ArrayList<File> result2 = new ArrayList<File>(this.myInstanceLibraries);
            ArrayList allRtClasses = new ArrayList(this.myRtClasses);
            allRtClasses.add(RemoteAgent.class);
            allRtClasses.add(Base64.class);
            allRtClasses.add(this.myAgentInterface);
            for (Class clazz : allRtClasses) {
                result2.add(new File(PathUtil.getJarPathForClass((Class)clazz)));
            }
            result2.addAll(this.myModuleDependencies);
            return result2;
        }

        public RemoteAgentManager.Builder<T> withRtDependency(@NotNull Class<?> rtClass) {
            this.myRtClasses.add(rtClass);
            return this;
        }

        public RemoteAgentManager.Builder<T> withInstanceLibraries(@NotNull List<File> libraries) {
            this.myInstanceLibraries.addAll(libraries);
            return this;
        }

        public RemoteAgentManager.Builder<T> withModuleDependency(@NotNull String runtimeModuleName, @NotNull String buildPathToJar) {
            if (this.myRunningFromSources) {
                File specificsModule = new File(this.myAllPluginsRoot, runtimeModuleName);
                this.myModuleDependencies.add(specificsModule);
            } else {
                File specificsDir = new File(this.myAllPluginsRoot, FileUtil.toSystemDependentName((String)buildPathToJar));
                this.myModuleDependencies.add(specificsDir);
            }
            return this;
        }
    }
}

