/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsBuilder {
    private String myInterpreterPath = null;
    private static final String myHelpersPath = null;
    private RemoteCredentials myRemoteCredentials = null;
    private static final String myHelpersDefaultDirName = ".idea_helpers";

    public RemoteSdkCredentials build() {
        RemoteSdkCredentialsHolder result2 = new RemoteSdkCredentialsHolder(myHelpersDefaultDirName);
        if (this.myRemoteCredentials != null) {
            RemoteSdkCredentialsBuilder.copyCredentials(this.myRemoteCredentials, result2);
        }
        if (this.myInterpreterPath != null) {
            result2.setInterpreterPath(this.myInterpreterPath);
        }
        if (myHelpersPath != null) {
            result2.setHelpersPath(myHelpersPath);
        }
        return result2;
    }

    public static void copyRemoteSdkCredentials(@NotNull RemoteSdkCredentials data2, @NotNull RemoteSdkCredentials copyTo2) {
        RemoteSdkCredentialsBuilder.copyCredentials(data2, copyTo2);
        copyTo2.setInterpreterPath(data2.getInterpreterPath());
        copyTo2.setRunAsRootViaSudo(data2.isRunAsRootViaSudo());
        copyTo2.setHelpersPath(data2.getHelpersPath());
        copyTo2.setHelpersVersionChecked(data2.isHelpersVersionChecked());
    }

    public static void copyCredentials(@NotNull RemoteCredentials data2, @NotNull MutableRemoteCredentials copyTo2) {
        copyTo2.setHost(data2.getHost());
        copyTo2.setLiteralPort(data2.getLiteralPort());
        copyTo2.setUserName(data2.getUserName());
        copyTo2.setPassword(data2.getPassword());
        copyTo2.setPrivateKeyFile(data2.getPrivateKeyFile());
        copyTo2.setPassphrase(data2.getPassphrase());
        copyTo2.setAuthType(data2.getAuthType());
        copyTo2.setStorePassword(data2.isStorePassword());
        copyTo2.setStorePassphrase(data2.isStorePassphrase());
    }

    public RemoteSdkCredentialsBuilder withCredentials(@Nullable RemoteCredentials remoteCredentials) {
        this.myRemoteCredentials = remoteCredentials;
        return this;
    }

    public RemoteSdkCredentialsBuilder withInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
        return this;
    }
}

