/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.collect.ImmutableMap;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteCredentialsHolder
implements MutableRemoteCredentials {
    private static final String SERVICE_NAME_PREFIX = "IntelliJ Platform Remote Credentials ";
    @NonNls
    public static final String HOST = "HOST";
    @NonNls
    public static final String PORT = "PORT";
    @NonNls
    public static final String ANONYMOUS = "ANONYMOUS";
    @NonNls
    public static final String USERNAME = "USERNAME";
    @NonNls
    public static final String PASSWORD = "PASSWORD";
    @NonNls
    public static final String USE_KEY_PAIR = "USE_KEY_PAIR";
    @NonNls
    public static final String USE_AUTH_AGENT = "USE_AUTH_AGENT";
    @NonNls
    public static final String PRIVATE_KEY_FILE = "PRIVATE_KEY_FILE";
    @NonNls
    public static final String PASSPHRASE = "PASSPHRASE";
    @NonNls
    public static final String SSH_PREFIX = "ssh://";
    private static final Map<AuthType, String> CREDENTIAL_ATTRIBUTES_QUALIFIERS = ImmutableMap.of((Object)((Object)AuthType.PASSWORD), (Object)"password", (Object)((Object)AuthType.KEY_PAIR), (Object)"passphrase", (Object)((Object)AuthType.OPEN_SSH), (Object)"empty");
    @NotNull
    private String myHost = "";
    private int myPort;
    @NotNull
    private String myLiteralPort = "";
    @Nullable
    private String myUserName;
    @Nullable
    private String myPassword;
    @NotNull
    private String myPrivateKeyFile = "";
    @Nullable
    private String myPassphrase;
    private boolean myStorePassword;
    private boolean myStorePassphrase;
    @NotNull
    private AuthType myAuthType = AuthType.PASSWORD;

    public RemoteCredentialsHolder() {
    }

    public RemoteCredentialsHolder(@NotNull RemoteCredentials credentials) {
        this.copyFrom(credentials);
    }

    public static String getCredentialsString(@NotNull RemoteCredentials cred) {
        return SSH_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
    }

    @Override
    @NotNull
    public String getHost() {
        return this.myHost;
    }

    @Override
    public void setHost(@Nullable String host) {
        this.myHost = StringUtil.notNullize((String)host);
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public void setPort(int port) {
        this.myPort = port;
        this.myLiteralPort = Integer.toString(port);
    }

    @Override
    @NotNull
    public String getLiteralPort() {
        return this.myLiteralPort;
    }

    @Override
    public void setLiteralPort(@Nullable String portText) {
        this.myLiteralPort = StringUtil.notNullize((String)portText);
        this.myPort = StringUtil.parseInt((String)portText, (int)0);
    }

    @Override
    @Transient
    @Nullable
    public String getUserName() {
        return this.myUserName;
    }

    @Override
    public void setUserName(@Nullable String userName) {
        this.myUserName = StringUtil.notNullize((String)userName);
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    @Override
    public void setPassword(@Nullable String password) {
        this.myPassword = StringUtil.notNullize((String)password);
    }

    @Override
    public void setStorePassword(boolean storePassword) {
        this.myStorePassword = storePassword;
    }

    @Override
    public void setStorePassphrase(boolean storePassphrase) {
        this.myStorePassphrase = storePassphrase;
    }

    @Override
    public boolean isStorePassword() {
        return this.myStorePassword;
    }

    @Override
    public boolean isStorePassphrase() {
        return this.myStorePassphrase;
    }

    @Override
    @NotNull
    public String getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    @Override
    public void setPrivateKeyFile(@Nullable String privateKeyFile) {
        this.myPrivateKeyFile = StringUtil.notNullize((String)privateKeyFile);
    }

    @Override
    @Transient
    @Nullable
    public String getPassphrase() {
        return this.myPassphrase;
    }

    @Override
    public void setPassphrase(@Nullable String passphrase) {
        this.myPassphrase = StringUtil.notNullize((String)passphrase);
    }

    @Override
    @NotNull
    public AuthType getAuthType() {
        return this.myAuthType;
    }

    @Override
    public void setAuthType(@NotNull AuthType authType) {
        this.myAuthType = authType;
    }

    @NotNull
    public String getSerializedUserName() {
        return StringUtil.notNullize((String)this.myUserName);
    }

    private void setSerializedUserName(@NonNls String userName) {
        this.myUserName = StringUtil.isEmpty((String)userName) ? null : userName;
    }

    private void setSerializedPassword(@NonNls @Nullable String serializedPassword) {
        if (!StringUtil.isEmpty((String)serializedPassword)) {
            this.myPassword = PasswordUtil.decodePassword((String)serializedPassword);
            this.myStorePassword = true;
        } else {
            this.myPassword = null;
        }
    }

    private void setSerializedPassphrase(@Nullable String serializedPassphrase) {
        if (!StringUtil.isEmpty((String)serializedPassphrase)) {
            this.myPassphrase = PasswordUtil.decodePassword((String)serializedPassphrase);
            this.myStorePassphrase = true;
        } else {
            this.myPassphrase = "";
            this.myStorePassphrase = false;
        }
    }

    public void copyRemoteCredentialsTo(@NotNull MutableRemoteCredentials to) {
        RemoteCredentialsHolder.copyRemoteCredentials(this, to);
    }

    public void copyFrom(@NotNull RemoteCredentials from) {
        RemoteCredentialsHolder.copyRemoteCredentials(from, this);
    }

    public static void copyRemoteCredentials(@NotNull RemoteCredentials from, @NotNull MutableRemoteCredentials to) {
        to.setHost(from.getHost());
        to.setLiteralPort(from.getLiteralPort());
        to.setUserName(from.getUserName());
        to.setPassword(from.getPassword());
        to.setPassphrase(from.getPassphrase());
        to.setAuthType(from.getAuthType());
        to.setPrivateKeyFile(from.getPrivateKeyFile());
        to.setStorePassword(from.isStorePassword());
        to.setStorePassphrase(from.isStorePassphrase());
    }

    public void load(Element element2) {
        boolean isAnonymous;
        this.setHost(element2.getAttributeValue(HOST));
        this.setLiteralPort(element2.getAttributeValue(PORT));
        this.setSerializedUserName(element2.getAttributeValue(USERNAME));
        this.setSerializedPassword(element2.getAttributeValue(PASSWORD));
        this.setPrivateKeyFile(StringUtil.nullize((String)element2.getAttributeValue(PRIVATE_KEY_FILE)));
        this.setSerializedPassphrase(element2.getAttributeValue(PASSPHRASE));
        boolean useKeyPair = Boolean.parseBoolean(element2.getAttributeValue(USE_KEY_PAIR));
        boolean useAuthAgent = Boolean.parseBoolean(element2.getAttributeValue(USE_AUTH_AGENT));
        this.myAuthType = useKeyPair ? AuthType.KEY_PAIR : (useAuthAgent ? AuthType.OPEN_SSH : AuthType.PASSWORD);
        CredentialAttributes attributes = this.createAttributes(false);
        Credentials credentials = PasswordSafe.getInstance().get(attributes);
        if (credentials != null) {
            boolean memoryOnly = PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
            if (this.myAuthType == AuthType.KEY_PAIR) {
                this.setPassword(null);
                this.setStorePassword(false);
                this.setPassphrase(credentials.getPasswordAsString());
                this.setStorePassphrase(!memoryOnly);
            } else if (this.myAuthType == AuthType.PASSWORD) {
                this.setPassword(credentials.getPasswordAsString());
                this.setStorePassword(!memoryOnly);
                this.setPassphrase(null);
                this.setStorePassphrase(false);
            } else {
                this.setPassword(null);
                this.setStorePassword(false);
                this.setPassphrase(null);
                this.setStorePassphrase(false);
            }
        }
        if (isAnonymous = Boolean.parseBoolean(element2.getAttributeValue(ANONYMOUS))) {
            this.setSerializedUserName("anonymous");
            this.setSerializedPassword("user@example.com");
        }
    }

    public void save(Element rootElement) {
        boolean memoryOnly;
        rootElement.setAttribute(HOST, StringUtil.notNullize((String)this.getHost()));
        rootElement.setAttribute(PORT, StringUtil.notNullize((String)this.getLiteralPort()));
        rootElement.setAttribute(USERNAME, this.getSerializedUserName());
        rootElement.setAttribute(PRIVATE_KEY_FILE, StringUtil.notNullize((String)this.getPrivateKeyFile()));
        rootElement.setAttribute(USE_KEY_PAIR, Boolean.toString(this.myAuthType == AuthType.KEY_PAIR));
        rootElement.setAttribute(USE_AUTH_AGENT, Boolean.toString(this.myAuthType == AuthType.OPEN_SSH));
        boolean bl = memoryOnly = this.myAuthType == AuthType.KEY_PAIR && !this.isStorePassphrase() || this.myAuthType == AuthType.PASSWORD && !this.isStorePassword() || this.myAuthType == AuthType.OPEN_SSH;
        String password = this.myAuthType == AuthType.KEY_PAIR ? this.getPassphrase() : (this.myAuthType == AuthType.PASSWORD ? this.getPassword() : null);
        PasswordSafe.getInstance().set(this.createAttributes(memoryOnly), new Credentials(this.getUserName(), password));
    }

    @NotNull
    private CredentialAttributes createAttributes(boolean memoryOnly) {
        String serviceName = SERVICE_NAME_PREFIX + RemoteCredentialsHolder.getCredentialsString(this) + "(" + CREDENTIAL_ATTRIBUTES_QUALIFIERS.get((Object)this.myAuthType) + ")";
        return new CredentialAttributes(serviceName, this.getUserName(), null, memoryOnly);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteCredentialsHolder holder = (RemoteCredentialsHolder)o;
        if (!this.myLiteralPort.equals(holder.myLiteralPort)) {
            return false;
        }
        if (this.myStorePassword != holder.myStorePassword) {
            return false;
        }
        if (this.myStorePassphrase != holder.myStorePassphrase) {
            return false;
        }
        if (!this.myHost.equals(holder.myHost)) {
            return false;
        }
        if (!Objects.equals(this.myUserName, holder.myUserName)) {
            return false;
        }
        if (!Objects.equals(this.myPassword, holder.myPassword)) {
            return false;
        }
        if (!this.myPrivateKeyFile.equals(holder.myPrivateKeyFile)) {
            return false;
        }
        if (!Objects.equals(this.myPassphrase, holder.myPassphrase)) {
            return false;
        }
        return this.myAuthType == holder.myAuthType;
    }

    public int hashCode() {
        int result2 = this.myHost.hashCode();
        result2 = 31 * result2 + this.myLiteralPort.hashCode();
        result2 = 31 * result2 + (this.myUserName != null ? this.myUserName.hashCode() : 0);
        result2 = 31 * result2 + (this.myPassword != null ? this.myPassword.hashCode() : 0);
        result2 = 31 * result2 + this.myPrivateKeyFile.hashCode();
        result2 = 31 * result2 + (this.myPassphrase != null ? this.myPassphrase.hashCode() : 0);
        result2 = 31 * result2 + (this.myStorePassword ? 1 : 0);
        result2 = 31 * result2 + (this.myStorePassphrase ? 1 : 0);
        result2 = 31 * result2 + this.myAuthType.hashCode();
        return result2;
    }
}

