/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RemoteConnectionType {
    DEFAULT_SDK,
    DEPLOYMENT_SERVER,
    SSH_CONFIG,
    REMOTE_SDK,
    CURRENT_VAGRANT,
    NONE;

    private static final Logger LOG;

    @NotNull
    public static RemoteConnectionType findByName(@Nullable String name) {
        if (name == null) {
            return NONE;
        }
        try {
            return RemoteConnectionType.valueOf(name);
        }
        catch (Exception e) {
            LOG.error("Cant find RemoteConnectionType with the name " + name, (Throwable)e);
            return NONE;
        }
    }

    static {
        LOG = Logger.getInstance(RemoteConnectionType.class);
    }
}

