/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Condition;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CredentialsTypeUtil {
    private CredentialsTypeUtil() {
    }

    public static boolean isCredentialsTypeSupportedForLanguage(@NotNull CredentialsType<?> credentialsType, @NotNull Class<?> languageContributionMarkerClass) {
        for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
            List<CredentialsLanguageContribution> contributions;
            CredentialsEditorProvider editorProvider;
            if (!credentialsType.equals(type) || (editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast(type, CredentialsEditorProvider.class)) == null || (contributions = CredentialsTypeUtil.getContributions(languageContributionMarkerClass)).isEmpty()) continue;
            for (CredentialsLanguageContribution contribution : contributions) {
                if (contribution.getType() != type || !editorProvider.isAvailable(contribution)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static <T> List<CredentialsLanguageContribution> getContributions(@NotNull Class<T> languageContributionMarkerInterface) {
        return ContainerUtil.filter((Object[])CredentialsLanguageContribution.EP_NAME.getExtensions(), (Condition)FilteringIterator.instanceOf(languageContributionMarkerInterface));
    }
}

