/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.io.BaseOutputReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRemoteProcessHandler<T extends RemoteProcess>
extends BaseProcessHandler<T> {
    private static final Logger LOG = Logger.getInstance(BaseRemoteProcessHandler.class);
    @NotNull
    private final ModalityState myModality = OSProcessHandler.getDefaultModality();

    public BaseRemoteProcessHandler(@NotNull T process2, String commandLine, @Nullable Charset charset) {
        super(process2, commandLine, charset);
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return new BaseOutputReader.Options();
    }

    protected void destroyProcessImpl() {
        if (!((RemoteProcess)this.myProcess).killProcessTree()) {
            super.destroyProcessImpl();
        }
    }

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myModality != ModalityState.NON_MODAL) {
            ProgressManager.getInstance().runProcess(() -> super.onOSProcessTerminated(exitCode), (ProgressIndicator)new EmptyProgressIndicator(this.myModality));
        } else {
            super.onOSProcessTerminated(exitCode);
        }
    }

    public void startNotify() {
        this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                try {
                    RemoteOutputReader stdoutReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getInputStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine, BaseRemoteProcessHandler.this.readerOptions()){

                        protected void onTextAvailable(@NotNull String text) {
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            return BaseRemoteProcessHandler.this.executeTask(runnable2);
                        }
                    };
                    RemoteOutputReader stderrReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getErrorStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine, BaseRemoteProcessHandler.this.readerOptions()){

                        protected void onTextAvailable(@NotNull String text) {
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDERR);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            return BaseRemoteProcessHandler.this.executeTask(runnable2);
                        }
                    };
                    BaseRemoteProcessHandler.this.myWaitFor.setTerminationCallback(exitCode -> {
                        try {
                            try {
                                stderrReader.waitFor();
                                stdoutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            BaseRemoteProcessHandler.this.onOSProcessTerminated((int)exitCode);
                        }
                    });
                }
                finally {
                    BaseRemoteProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    @NotNull
    public Future<?> executeTask(@NotNull Runnable task2) {
        return ApplicationManager.getApplication().executeOnPooledThread(task2);
    }

    private static abstract class RemoteOutputReader
    extends BaseOutputReader {
        @NotNull
        private final RemoteProcess myRemoteProcess;
        private boolean myClosed;

        RemoteOutputReader(@NotNull InputStream inputStream, Charset charset, @NotNull RemoteProcess remoteProcess, @NotNull String commandLine, @NotNull BaseOutputReader.Options options2) {
            super(inputStream, charset, options2);
            this.myRemoteProcess = remoteProcess;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine));
        }

        protected void doRun() {
            try {
                this.setClosed(false);
                while (true) {
                    boolean read = this.readAvailable();
                    if (this.myRemoteProcess.isDisconnected()) {
                        this.myReader.close();
                        break;
                    }
                    if (this.isStopped) {
                        break;
                    }
                    Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read));
                }
            }
            catch (InterruptedException read) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this.setClosed(true);
            }
        }

        protected synchronized void setClosed(boolean closed) {
            this.myClosed = closed;
        }

        public void waitFor() throws InterruptedException {
            while (!this.isClosed()) {
                Thread.sleep(100L);
            }
        }

        private synchronized boolean isClosed() {
            return this.myClosed;
        }
    }
}

