/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicatorKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRenameData;
import com.intellij.refactoring.suggested.TextRangeUtilsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a&\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a8\u0006\r"}, d2={"intentionActionShortcutHint", "", "changeSignatureAvailabilityRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "declaration", "Lcom/intellij/psi/PsiElement;", "update", "", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;", "refactoringData", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringData;", "refactoringSupport", "intellij.platform.lang.impl"})
public final class SuggestedRefactoringAvailabilityIndicatorKt {
    public static final void update(@NotNull SuggestedRefactoringAvailabilityIndicator $this$update, @NotNull PsiElement declaration, @Nullable SuggestedRefactoringData refactoringData, @NotNull SuggestedRefactoringSupport refactoringSupport) {
        PsiFile psiFile = declaration.getContainingFile();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document document2 = document;
        boolean bl = psiDocumentManager.isCommitted(document2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean refactoringAvailable = false;
        String tooltip = null;
        TextRange markerRange = null;
        TextRange availabilityRange = null;
        SuggestedRefactoringData suggestedRefactoringData = refactoringData;
        if (suggestedRefactoringData instanceof SuggestedRenameData) {
            refactoringAvailable = true;
            tooltip = RefactoringBundle.message((String)"suggested.refactoring.rename.gutter.icon.tooltip", (Object[])new Object[]{((SuggestedRenameData)refactoringData).getOldName(), ((SuggestedRenameData)refactoringData).getDeclaration().getName(), SuggestedRefactoringAvailabilityIndicatorKt.intentionActionShortcutHint()});
            TextRange textRange = refactoringSupport.nameRange((PsiElement)((SuggestedRenameData)refactoringData).getDeclaration());
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            availabilityRange = markerRange = textRange;
        } else if (suggestedRefactoringData instanceof SuggestedChangeSignatureData) {
            refactoringAvailable = true;
            tooltip = RefactoringBundle.message((String)"suggested.refactoring.change.signature.gutter.icon.tooltip", (Object[])new Object[]{((SuggestedChangeSignatureData)refactoringData).getNameOfStuffToUpdate(), ((SuggestedChangeSignatureData)refactoringData).getOldSignature().getName(), SuggestedRefactoringAvailabilityIndicatorKt.intentionActionShortcutHint()});
            TextRange textRange = refactoringSupport.nameRange(refactoringData.getDeclaration());
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            markerRange = textRange;
            availabilityRange = SuggestedRefactoringAvailabilityIndicatorKt.changeSignatureAvailabilityRange(refactoringSupport, refactoringData.getDeclaration());
        } else if (suggestedRefactoringData == null) {
            refactoringAvailable = false;
            tooltip = SuggestedRefactoringAvailabilityIndicator.Companion.getDisabledRefactoringTooltip();
            TextRange textRange = refactoringSupport.nameRange(declaration);
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            markerRange = textRange;
            availabilityRange = SuggestedRefactoringAvailabilityIndicatorKt.changeSignatureAvailabilityRange(refactoringSupport, declaration);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0<Unit> $fun$doUpdate$1 = new Function0<Unit>($this$update, availabilityRange, document2, markerRange, refactoringAvailable, tooltip){
            final /* synthetic */ SuggestedRefactoringAvailabilityIndicator $this_update;
            final /* synthetic */ TextRange $availabilityRange;
            final /* synthetic */ Document $document;
            final /* synthetic */ TextRange $markerRange;
            final /* synthetic */ boolean $refactoringAvailable;
            final /* synthetic */ String $tooltip;

            public final void invoke() {
                if (this.$availabilityRange != null) {
                    this.$this_update.show(this.$document, this.$markerRange, this.$availabilityRange, this.$refactoringAvailable, this.$tooltip);
                } else {
                    this.$this_update.clear();
                }
            }
            {
                this.$this_update = suggestedRefactoringAvailabilityIndicator;
                this.$availabilityRange = textRange;
                this.$document = document;
                this.$markerRange = textRange2;
                this.$refactoringAvailable = bl;
                this.$tooltip = string;
                super(0);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            $fun$doUpdate$1.invoke();
        } else {
            long modificationStamp = document2.getModificationStamp();
            ApplicationManager.getApplication().invokeLater(new Runnable(document2, modificationStamp, $fun$doUpdate$1){
                final /* synthetic */ Document $document;
                final /* synthetic */ long $modificationStamp;
                final /* synthetic */ update.1 $doUpdate$1;

                public final void run() {
                    if (this.$document.getModificationStamp() == this.$modificationStamp) {
                        this.$doUpdate$1.invoke();
                    }
                }
                {
                    this.$document = document;
                    this.$modificationStamp = l;
                    this.$doUpdate$1 = var4_3;
                }
            });
        }
    }

    private static final String intentionActionShortcutHint() {
        KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowIntentionActions");
        if (keyboardShortcut == null) {
            return "";
        }
        KeyboardShortcut shortcut = keyboardShortcut;
        return '(' + KeymapUtil.getShortcutText((Shortcut)((Shortcut)shortcut)) + ')';
    }

    @Nullable
    public static final TextRange changeSignatureAvailabilityRange(@NotNull SuggestedRefactoringSupport $this$changeSignatureAvailabilityRange, @NotNull PsiElement declaration) {
        PsiFile file2 = declaration.getContainingFile();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = psiDocumentManager.getDocument(file2);
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document document2 = document;
        boolean bl = psiDocumentManager.isCommitted(document2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TextRange textRange = $this$changeSignatureAvailabilityRange.signatureRange(declaration);
        return textRange != null ? TextRangeUtilsKt.extend((TextRange)textRange, (CharSequence)document2.getCharsSequence(), (Function1)changeSignatureAvailabilityRange.1.INSTANCE) : null;
    }
}

