/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenameHandler
implements RenameHandler {
    private static final ThreadLocal<String> ourPreventInlineRenameFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(VariableInplaceRenameHandler.class);

    public final boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element2 = PsiElementRenameHandler.getElement(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file2 == null) {
            return false;
        }
        if (ourPreventInlineRenameFlag.get() != null) {
            return false;
        }
        return this.isAvailable(element2, editor, file2);
    }

    protected boolean isAvailable(@Nullable PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = element2 == null ? null : LanguageRefactoringSupport.INSTANCE.forContext(element2);
        return supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceRenameAvailable(element2, nameSuggestionContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element2 = PsiElementRenameHandler.getElement(dataContext);
        if (element2 == null) {
            if (LookupManager.getActiveLookup(editor) != null) {
                PsiElement elementUnderCaret = file2.findElementAt(editor.getCaretModel().getOffset());
                if (elementUnderCaret != null) {
                    PsiElement parent = elementUnderCaret.getParent();
                    element2 = parent instanceof PsiReference ? ((PsiReference)parent).resolve() : PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PsiNamedElement.class);
                }
                if (element2 == null) {
                    return;
                }
            } else {
                return;
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (this.checkAvailable(element2, editor, dataContext)) {
            this.doRename(element2, editor, dataContext);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, @NotNull DataContext dataContext) {
        PsiElement element2;
        PsiElement psiElement = element2 = elements2.length == 1 ? elements2[0] : null;
        if (element2 == null) {
            element2 = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element2 != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (this.checkAvailable(element2, editor, dataContext)) {
            assert (editor != null);
            this.doRename(element2, editor, dataContext);
        }
    }

    protected boolean checkAvailable(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        if (!this.isAvailableOnDataContext(dataContext)) {
            LOG.error("Recursive invocation");
            RenameHandler handler2 = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
            if (handler2 == null) {
                return false;
            }
            handler2.invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
            return false;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        return true;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor, @Nullable DataContext dataContext) {
        boolean startedRename;
        VariableInplaceRenamer renamer = this.createRenamer(elementToRename, editor);
        boolean bl = startedRename = renamer != null && renamer.performInplaceRename();
        if (!startedRename) {
            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, renamer != null ? renamer.myInitialName : null);
        }
        return renamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext, String initialName) {
        try {
            ourPreventInlineRenameFlag.set(initialName == null ? "" : initialName);
            RenameHandler handler2 = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
            assert (handler2 != null) : elementToRename.getClass().getName() + ":" + elementToRename;
            handler2.invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
        }
        finally {
            ourPreventInlineRenameFlag.set(null);
        }
    }

    @Nullable
    public static String getInitialName() {
        String str = ourPreventInlineRenameFlag.get();
        return StringUtil.isEmpty((String)str) ? null : str;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        return new VariableInplaceRenamer((PsiNamedElement)elementToRename, editor);
    }
}

