/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @Override
    protected boolean isAvailable(@Nullable PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        if (nameSuggestionContext == null && editor.getCaretModel().getOffset() > 0) {
            nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        if (element2 == null && LookupManager.getActiveLookup(editor) != null) {
            element2 = PsiTreeUtil.getParentOfType((PsiElement)nameSuggestionContext, PsiNamedElement.class);
        }
        RefactoringSupportProvider supportProvider = element2 == null ? null : LanguageRefactoringSupport.INSTANCE.forContext(element2);
        return editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider != null && element2 instanceof PsiNameIdentifierOwner && supportProvider.isMemberInplaceRenameAvailable(element2, nameSuggestionContext);
    }

    @Override
    public InplaceRefactoring doRename(final @NotNull PsiElement elementToRename, final @NotNull Editor editor, final @Nullable DataContext dataContext) {
        RenamePsiElementProcessor processor2;
        if (elementToRename instanceof PsiNameIdentifierOwner && (processor2 = RenamePsiElementProcessor.forElement(elementToRename)).isInplaceRenameSupported()) {
            TemplateState templateState;
            StartMarkAction startMarkAction = StartMarkAction.canStart(elementToRename.getProject());
            if (startMarkAction == null || processor2.substituteElementToRename(elementToRename, editor) == elementToRename) {
                processor2.substituteElementToRename(elementToRename, editor, new Pass<PsiElement>(){

                    public void pass(PsiElement element2) {
                        MemberInplaceRenamer renamer = MemberInplaceRenameHandler.this.createMemberRenamer(element2, (PsiNameIdentifierOwner)elementToRename, editor);
                        boolean startedRename = renamer.performInplaceRename();
                        if (!startedRename) {
                            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, renamer.myInitialName);
                        }
                    }
                });
                return null;
            }
            InplaceRefactoring inplaceRefactoring = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
            if (inplaceRefactoring != null && inplaceRefactoring.getClass() == MemberInplaceRenamer.class && (templateState = TemplateManagerImpl.getTemplateState(InjectedLanguageUtil.getTopLevelEditor(editor))) != null) {
                templateState.gotoEnd(true);
            }
        }
        MemberInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, null);
        return null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element2, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor) {
        return new MemberInplaceRenamer((PsiNamedElement)elementToRename, element2, editor);
    }
}

