/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameterObject;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceParameterObjectClassDescriptor<M extends PsiNamedElement, P extends ParameterInfo> {
    @NotNull
    private final String myClassName;
    private final String myPackageName;
    private final boolean myUseExistingClass;
    private final boolean myCreateInnerClass;
    private final String myNewVisibility;
    private final boolean myGenerateAccessors;
    private final P[] myParamsToMerge;
    private PsiElement myExistingClass;
    private M myExistingClassCompatibleConstructor;

    public IntroduceParameterObjectClassDescriptor(@NotNull String className, String packageName, boolean useExistingClass, boolean createInnerClass, String newVisibility, boolean generateAccessors, P[] parameters2) {
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myUseExistingClass = useExistingClass;
        this.myCreateInnerClass = createInnerClass;
        this.myNewVisibility = newVisibility;
        this.myGenerateAccessors = generateAccessors;
        this.myParamsToMerge = parameters2;
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    public String getPackageName() {
        return this.myPackageName;
    }

    public boolean isUseExistingClass() {
        return this.myUseExistingClass;
    }

    public boolean isCreateInnerClass() {
        return this.myCreateInnerClass;
    }

    public String getNewVisibility() {
        return this.myNewVisibility;
    }

    public P[] getParamsToMerge() {
        return this.myParamsToMerge;
    }

    public PsiElement getExistingClass() {
        return this.myExistingClass;
    }

    public void setExistingClass(PsiElement existingClass) {
        this.myExistingClass = existingClass;
    }

    public boolean isGenerateAccessors() {
        return this.myGenerateAccessors;
    }

    public P getParameterInfo(int oldIndex) {
        for (P info : this.myParamsToMerge) {
            if (info.getOldIndex() != oldIndex) continue;
            return info;
        }
        return null;
    }

    public abstract String getSetterName(P var1, @NotNull PsiElement var2);

    public abstract String getGetterName(P var1, @NotNull PsiElement var2);

    @Nullable
    public abstract M findCompatibleConstructorInExistingClass(M var1);

    public M getExistingClassCompatibleConstructor() {
        return this.myExistingClassCompatibleConstructor;
    }

    public void setExistingClassCompatibleConstructor(M existingClassCompatibleConstructor) {
        this.myExistingClassCompatibleConstructor = existingClassCompatibleConstructor;
    }

    public abstract PsiElement createClass(M var1, ReadWriteAccessDetector.Access[] var2);
}

