/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler<Target extends IntroduceTarget, Scope extends PsiElement>
implements RefactoringActionHandler {
    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (editor == null || file2 == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int caretCount = editor.getCaretModel().getCaretCount();
        if (caretCount != 1) {
            this.cannotPerformRefactoring(project, editor);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            this.invokeOnSelection(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), project, editor, file2);
        } else {
            Pair<List<Target>, Integer> targetInfo = this.collectTargets(file2, editor, project);
            List list2 = (List)targetInfo.getFirst();
            if (list2.isEmpty()) {
                this.cannotPerformRefactoring(project, editor);
            } else if (list2.size() == 1) {
                this.invokeOnTarget((IntroduceTarget)list2.get(0), file2, editor, project);
            } else {
                IntroduceTargetChooser.showIntroduceTargetChooser(editor, list2, new Pass<Target>(){

                    public void pass(Target target2) {
                        IntroduceHandler.this.invokeOnTarget(target2, file2, editor, project);
                    }
                }, RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"), (Integer)targetInfo.getSecond());
            }
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
    }

    private void invokeOnTarget(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        String message = this.checkSelectedTarget(target2, file2, editor, project);
        if (message != null) {
            this.showErrorHint(message, editor, project);
            return;
        }
        this.invokeScopeStep(target2, file2, editor, project);
    }

    private void invokeOnSelection(int start2, int end, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Target target2 = this.findSelectionTarget(start2, end, file2, editor, project);
        if (target2 != null) {
            this.invokeScopeStep(target2, file2, editor, project);
        } else {
            this.cannotPerformRefactoring(project, editor);
        }
    }

    private void invokeScopeStep(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        List<Scope> scopes = this.collectTargetScopes(target2, editor, file2, project);
        if (scopes.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)this.getEmptyScopeErrorMessage());
            this.showErrorHint(message, editor, project);
            return;
        }
        if (scopes.size() == 1) {
            this.invokeFindUsageStep(target2, (PsiElement)scopes.get(0), file2, editor, project);
        } else {
            PsiElement[] scopeArray = PsiUtilCore.toPsiElementArray(scopes);
            NavigationUtil.getPsiElementPopup((PsiElement[])scopeArray, this.getScopeRenderer(), (String)this.getChooseScopeTitle(), scope -> {
                this.invokeFindUsageStep(target2, scope, file2, editor, project);
                return false;
            }).showInBestPositionFor(editor);
        }
    }

    private void invokeFindUsageStep(@NotNull Target target2, @NotNull Scope scope, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        List<UsageInfo> usages = this.collectUsages(target2, scope);
        String message = this.checkUsages(usages);
        if (message != null) {
            this.showErrorHint(message, editor, project);
            return;
        }
        this.invokeDialogStep(target2, scope, usages, file2, editor, project);
    }

    private void invokeDialogStep(final @NotNull Target target2, final @NotNull Scope scope, final @NotNull List<UsageInfo> usages, final @NotNull PsiFile file2, final @NotNull Editor editor, final @NotNull Project project) {
        Map occurrencesMap = this.getOccurrenceOptions(target2, usages);
        OccurrencesChooser<Object> chooser = new OccurrencesChooser<Object>(editor){

            @Override
            protected TextRange getOccurrenceRange(Object occurrence) {
                return IntroduceHandler.this.getOccurrenceRange(occurrence);
            }
        };
        chooser.showChooser(new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                AbstractInplaceIntroducer<?, ?> introducer = IntroduceHandler.this.getIntroducer(target2, scope, usages, choice, file2, editor, project);
                introducer.startInplaceIntroduceTemplate();
            }
        }, occurrencesMap);
    }

    @NotNull
    private TextRange getOccurrenceRange(@NotNull Object occurrence) {
        if (occurrence instanceof PsiElement) {
            return ((PsiElement)occurrence).getTextRange();
        }
        if (occurrence instanceof UsageInfo) {
            Segment segment = ((UsageInfo)occurrence).getSegment();
            assert (segment != null);
            return TextRange.create((Segment)segment);
        }
        return ((IntroduceTarget)occurrence).getTextRange();
    }

    @NotNull
    private Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull Target target2, @NotNull List<UsageInfo> usages) {
        LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<Object>> map2 = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<Object>>();
        map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(target2));
        if (usages.size() > 1) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, new ArrayList<UsageInfo>(usages));
        }
        return map2;
    }

    @NotNull
    protected abstract List<UsageInfo> collectUsages(@NotNull Target var1, @NotNull Scope var2);

    @Nullable
    protected abstract String checkUsages(@NotNull List<UsageInfo> var1);

    @NotNull
    protected abstract List<Scope> collectTargetScopes(@NotNull Target var1, @NotNull Editor var2, @NotNull PsiFile var3, @NotNull Project var4);

    @NotNull
    protected abstract Pair<List<Target>, Integer> collectTargets(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull Project var3);

    @Nullable
    protected abstract Target findSelectionTarget(int var1, int var2, @NotNull PsiFile var3, @NotNull Editor var4, @NotNull Project var5);

    @Nullable
    protected abstract String checkSelectedTarget(@NotNull Target var1, @NotNull PsiFile var2, @NotNull Editor var3, @NotNull Project var4);

    @NotNull
    protected abstract String getRefactoringName();

    @Nullable
    protected abstract String getHelpID();

    @NotNull
    protected abstract String getChooseScopeTitle();

    @NotNull
    protected abstract PsiElementListCellRenderer<Scope> getScopeRenderer();

    @NotNull
    protected abstract AbstractInplaceIntroducer<?, ?> getIntroducer(@NotNull Target var1, @NotNull Scope var2, @NotNull List<UsageInfo> var3, @NotNull OccurrencesChooser.ReplaceChoice var4, @NotNull PsiFile var5, @NotNull Editor var6, @NotNull Project var7);

    @NotNull
    protected String getEmptyScopeErrorMessage() {
        return this.getRefactoringName() + " is not available in the current scope";
    }

    protected void showErrorHint(@NotNull String errorMessage, @NotNull Editor editor, @NotNull Project project) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)this.getRefactoringName(), (String)this.getHelpID());
    }

    private void cannotPerformRefactoring(@NotNull Project project, @NotNull Editor editor) {
        this.showErrorHint(RefactoringBundle.message((String)"cannot.perform.refactoring"), editor, project);
    }
}

