/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ExtractMethodHelper {
    public static void processDuplicates(final @NotNull PsiElement callElement, final @NotNull PsiElement generatedMethod, final @NotNull List<PsiElement> scope, final @NotNull SimpleDuplicatesFinder finder, final @NotNull Editor editor, final @NotNull Consumer<? super Pair<SimpleMatch, PsiElement>> replacer) {
        finder.setReplacement(callElement);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExtractMethodHelper.replaceDuplicates(callElement, editor, replacer, finder.findDuplicates(scope, generatedMethod));
            return;
        }
        Project project = callElement.getProject();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, RefactoringBundle.message((String)"searching.for.duplicates"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (this.myProject == null || this.myProject.isDisposed()) {
                    return;
                }
                List duplicates = (List)ReadAction.compute(() -> finder.findDuplicates(scope, generatedMethod));
                ApplicationManager.getApplication().invokeLater(() -> ExtractMethodHelper.replaceDuplicates(callElement, editor, (Consumer<? super Pair<SimpleMatch, PsiElement>>)replacer, duplicates));
            }
        });
    }

    @NotNull
    public static List<SimpleMatch> collectDuplicates(@NotNull SimpleDuplicatesFinder finder, @NotNull List<PsiElement> searchScopes, @NotNull PsiElement generatedMethod) {
        Project project = generatedMethod.getProject();
        try {
            return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                return (List)ReadAction.compute(() -> finder.findDuplicates(searchScopes, generatedMethod));
            }, RefactoringBundle.message((String)"searching.for.duplicates"), true, project);
        }
        catch (ProcessCanceledException e) {
            return Collections.emptyList();
        }
    }

    public static void replaceDuplicates(@NotNull PsiElement callElement, @NotNull Editor editor, @NotNull Consumer<? super Pair<SimpleMatch, PsiElement>> replacer, @NotNull List<? extends SimpleMatch> duplicates) {
        if (!duplicates.isEmpty()) {
            int exitCode;
            String message = RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()});
            boolean isUnittest = ApplicationManager.getApplication().isUnitTestMode();
            boolean isPerformanceScript = System.getProperty("testscript.filename") != null;
            Project project = callElement.getProject();
            int n = exitCode = !isUnittest && !isPerformanceScript ? Messages.showYesNoDialog((Project)project, (String)message, (String)RefactoringBundle.message((String)"refactoring.extract.method.dialog.title"), (Icon)Messages.getInformationIcon()) : 0;
            if (exitCode == 0) {
                boolean replaceAll = false;
                HashMap<SimpleMatch, RangeHighlighter> highlighterMap = new HashMap<SimpleMatch, RangeHighlighter>();
                for (SimpleMatch simpleMatch : duplicates) {
                    if (!simpleMatch.getStartElement().isValid() || !simpleMatch.getEndElement().isValid()) continue;
                    Pair replacement = Pair.create((Object)simpleMatch, (Object)callElement);
                    if (!replaceAll) {
                        ExtractMethodHelper.highlightInEditor(project, simpleMatch, editor, highlighterMap);
                        int promptResult = 3;
                        if (!isUnittest && !isPerformanceScript) {
                            ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"replace.fragment"), project);
                            promptDialog.show();
                            promptResult = promptDialog.getExitCode();
                        }
                        if (promptResult == 2) {
                            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                            RangeHighlighter highlighter = (RangeHighlighter)highlighterMap.get(simpleMatch);
                            if (highlighter == null) continue;
                            highlightManager.removeSegmentHighlighter(editor, highlighter);
                            continue;
                        }
                        if (promptResult == 1) break;
                        if (promptResult == 0) {
                            ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                            continue;
                        }
                        if (promptResult != 3) continue;
                        ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                        replaceAll = true;
                        continue;
                    }
                    ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                }
            }
        }
    }

    private static void replaceDuplicate(Project project, Consumer<? super Pair<SimpleMatch, PsiElement>> replacer, Pair<SimpleMatch, PsiElement> replacement) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> replacer.consume((Object)replacement)), RefactoringBundle.message((String)"extract.method.replace.duplicate.command.name"), null);
    }

    private static void highlightInEditor(@NotNull Project project, @NotNull SimpleMatch match, @NotNull Editor editor, Map<SimpleMatch, RangeHighlighter> highlighterMap) {
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        int startOffset = match.getStartElement().getTextRange().getStartOffset();
        int endOffset = match.getEndElement().getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
        highlighterMap.put(match, (RangeHighlighter)highlighters.get(0));
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }
}

