/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.RenameFileActionProvider;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import org.jetbrains.annotations.NotNull;

public class RenameFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file2 != null);
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        PsiElementRenameHandler.invoke((PsiElement)file2, project, (PsiElement)file2, null);
    }

    public void update(@NotNull AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation2 = e.getPresentation();
        String place = e.getPlace();
        boolean enabled = file2 != null && (this.enabledInProjectView(file2) || !"ProjectViewPopup".equals(place)) && place != "EditorPopup" && e.getData(CommonDataKeys.PROJECT) != null;
        presentation2.setEnabledAndVisible(enabled);
    }

    protected boolean enabledInProjectView(@NotNull PsiFile file2) {
        return RenameFileActionProvider.EP_NAME.getExtensionList().stream().anyMatch(provider -> provider.enabledInProjectView(file2));
    }
}

