/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import org.jetbrains.annotations.NotNull;

public class RenameElementAction
extends BaseRefactoringAction {
    public RenameElementAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2.length != 1) {
            return false;
        }
        PsiElement element2 = elements2[0];
        return element2 instanceof PsiNamedElement && !(element2 instanceof SyntheticElement) && !PsiElementRenameHandler.isVetoed(element2);
    }

    @Override
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
    }

    @Override
    protected boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        return this.isEnabledOnDataContext(dataContext);
    }

    @Override
    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        return RenameHandlerRegistry.getInstance().hasAvailableHandler(dataContext);
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        return this.isEnabledOnDataContext(context);
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context, @NotNull String place) {
        return this.isEnabledOnDataContext(context);
    }
}

