/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.inline.InlineRefactoringActionHandler;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineAction
extends BasePlatformRefactoringAction {
    public InlineAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        return InlineAction.hasInlineActionHandler(element2, PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)element2.getProject()), editor);
    }

    @Override
    public boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        return elements2.length == 1 && InlineAction.hasInlineActionHandler(elements2[0], null, null);
    }

    private static boolean hasInlineActionHandler(PsiElement element2, @Nullable Language editorLanguage, Editor editor) {
        for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
            if (!handler2.isEnabledOnElement(element2, editor)) continue;
            return true;
        }
        List handlers = InlineHandlers.getInlineHandlers((Language)(editorLanguage != null ? editorLanguage : element2.getLanguage()));
        for (InlineHandler handler3 : handlers) {
            if (!handler3.canInlineElement(element2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        return new InlineRefactoringActionHandler();
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element2) {
        RefactoringActionHandler handler2 = super.getHandler(language, element2);
        if (handler2 != null) {
            return handler2;
        }
        List handlers = InlineHandlers.getInlineHandlers((Language)language);
        return handlers.isEmpty() ? null : new InlineRefactoringActionHandler();
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
            if (!handler2.isEnabledForLanguage(language)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)language).size() > 0;
    }

    @Override
    @Nullable
    protected String getActionName(@NotNull DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        PsiElement element2 = this.findRefactoringTargetInEditor(dataContext);
        if (element2 != null && editor != null) {
            for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
                if (!handler2.isEnabledOnElement(element2, editor)) continue;
                return handler2.getActionName(element2);
            }
        }
        return super.getActionName(dataContext);
    }
}

