/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SameSourceRootWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<VirtualFile, ProximityLocation> SOURCE_ROOT_KEY = NullableLazyKey.create((String)"sourceRoot", proximityLocation -> SameSourceRootWeigher.findSourceRoot(proximityLocation.getPosition()));

    @Override
    public Comparable weigh(@NotNull PsiElement element2, @NotNull ProximityLocation location) {
        if (location.getPosition() == null) {
            return null;
        }
        VirtualFile sourceRoot = (VirtualFile)SOURCE_ROOT_KEY.getValue((UserDataHolder)location);
        if (sourceRoot == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(sourceRoot.equals(SameSourceRootWeigher.findSourceRoot(element2)));
    }

    private static VirtualFile findSourceRoot(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return ProjectFileIndex.getInstance((Project)element2.getProject()).getSourceRootForFile(file2);
    }
}

