/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.util.ReflectionUtil;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IStubFileElementType<T extends PsiFileStub>
extends StubFileElementType<T> {
    private static volatile int templateStubVersion = -1;

    public IStubFileElementType(Language language) {
        super(language);
    }

    public IStubFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
        if (this.hasNonTrivialExternalId() && !this.isOutOfOurControl()) {
            IStubElementType.checkNotInstantiatedTooLate();
        }
    }

    private boolean hasNonTrivialExternalId() {
        return ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getExternalId", (Class[])new Class[0]) != IStubFileElementType.class;
    }

    private boolean isOutOfOurControl() {
        return ((Object)((Object)this)).getClass().getName().contains(".kotlin.");
    }

    public int getStubVersion() {
        return this.getLanguage() instanceof TemplateLanguage ? IStubFileElementType.getTemplateStubVersion() : 0;
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder();
    }

    @NonNls
    @NotNull
    public String getExternalId() {
        return "psi.file";
    }

    public void serialize(@NotNull T stub, @NotNull StubOutputStream dataStream) throws IOException {
    }

    @NotNull
    public T deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        return (T)((Object)new PsiFileStubImpl<Object>(null));
    }

    public void indexStub(@NotNull PsiFileStub stub, @NotNull IndexSink sink) {
    }

    public boolean shouldBuildStubFor(VirtualFile file2) {
        return true;
    }

    public static int getTemplateStubVersion() {
        if (templateStubVersion == -1) {
            templateStubVersion = IStubFileElementType.calcStubVersion();
        }
        return templateStubVersion;
    }

    private static int calcStubVersion() {
        IElementType[] dataElementTypes = IElementType.enumerate(elementType -> elementType instanceof IStubFileElementType && !(elementType.getLanguage() instanceof TemplateLanguage));
        return Arrays.stream(dataElementTypes).mapToInt(e -> ((IStubFileElementType)((Object)e)).getStubVersion()).sum();
    }
}

