/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubProcessingHelperBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubProcessingHelper
extends StubProcessingHelperBase {
    private final ThreadLocal<Set<VirtualFile>> myFilesHavingProblems = new ThreadLocal();

    @Nullable
    public <Key, Psi extends PsiElement> StubIdList retrieveStubIdList(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull VirtualFile file2, @NotNull Project project) {
        int id2 = ((VirtualFileWithId)file2).getId();
        try {
            Map<Integer, SerializedStubTree> data2 = StubIndexImpl.getStubUpdatingIndex().getIndexedFileData(id2);
            if (data2.size() != 1) {
                LOG.error("Stub index points to a file (" + StubProcessingHelper.getFileTypeInfo(file2, project) + ") without indexed stub tree");
                this.onInternalError(file2);
                return null;
            }
            SerializedStubTree tree = data2.values().iterator().next();
            StubIdList stubIdList = tree.restoreIndexedStubs(indexKey, key);
            if (stubIdList == null) {
                String additionalMessage;
                String mainMessage = "Stub ids not found for key in index = " + indexKey.getName() + ", " + StubProcessingHelper.getFileTypeInfo(file2, project);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = null;
                    try {
                        tree.restoreIndexedStubs();
                        map2 = tree.getStubIndicesValueMap();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    additionalMessage = ", file " + file2.getPath() + ", for key " + key + " existing map " + map2;
                } else {
                    additionalMessage = "";
                }
                LOG.error(mainMessage + additionalMessage);
                this.onInternalError(file2);
            }
            return stubIdList;
        }
        catch (StorageException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onInternalError(VirtualFile file2) {
        THashSet set = this.myFilesHavingProblems.get();
        if (set == null) {
            set = new THashSet();
            this.myFilesHavingProblems.set((Set<VirtualFile>)set);
        }
        set.add((VirtualFile)file2);
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> FileBasedIndex.getInstance().requestReindex(file2));
    }

    @Nullable
    Set<VirtualFile> takeAccumulatedFilesWithIndexProblems() {
        Set<VirtualFile> filesWithProblems = this.myFilesHavingProblems.get();
        if (filesWithProblems != null) {
            this.myFilesHavingProblems.set(null);
        }
        return filesWithProblems;
    }

    boolean areAllProblemsProcessedInTheCurrentThread() {
        return ContainerUtil.isEmpty((Collection)this.myFilesHavingProblems.get());
    }
}

