/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.packageSet.FilteredPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.IdeUICustomization;
import org.jetbrains.annotations.NotNull;

public final class NonProjectFilesScope
extends NamedScope {
    public static final String NAME = IdeUICustomization.getInstance().projectMessage("scope.name.non.project.files", new Object[0]);
    public static final NonProjectFilesScope INSTANCE = new NonProjectFilesScope();

    private NonProjectFilesScope() {
        super(NAME, (PackageSet)new FilteredPackageSet(NAME){

            public boolean contains(@NotNull VirtualFile file2, @NotNull Project project) {
                return NonProjectFilesScope.containsImpl(file2, project);
            }
        });
    }

    private static boolean containsImpl(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        if (!file2.isInLocalFileSystem()) {
            return true;
        }
        if (ScratchUtil.isScratch(file2)) {
            return false;
        }
        return !ProjectScope.getProjectScope((Project)project).contains(file2);
    }

    public String getDefaultColorName() {
        return "Yellow";
    }
}

