/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class EditorSelectionLocalSearchScope
extends LocalSearchScope {
    private final Editor myEditor;
    private final Project myProject;
    private PsiElement[] myPsiElements;
    private VirtualFile[] myVirtualFiles;
    private TextRange[] myRanges;
    private final boolean myIgnoreInjectedPsi;
    @NotNull
    private final String myDisplayName;
    private LocalSearchScope myLocalSearchScope;

    private void initVirtualFilesAndRanges() {
        if (this.myRanges != null) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.myVirtualFiles = VirtualFile.EMPTY_ARRAY;
            this.myRanges = TextRange.EMPTY_ARRAY;
            return;
        }
        this.myVirtualFiles = new VirtualFile[]{FileDocumentManager.getInstance().getFile(this.myEditor.getDocument())};
        int[] selectionStarts = selectionModel.getBlockSelectionStarts();
        int[] selectionEnds = selectionModel.getBlockSelectionEnds();
        this.myRanges = new TextRange[selectionStarts.length];
        for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
            this.myRanges[i2] = new TextRange(selectionStarts[i2], selectionEnds[i2]);
        }
    }

    private void init() {
        ReadAction.run(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            if (psiFile == null) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            int[] selectionStarts = selectionModel.getBlockSelectionStarts();
            int[] selectionEnds = selectionModel.getBlockSelectionEnds();
            ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
            for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
                PsiElement parent;
                int end;
                PsiElement endElement;
                int start2 = selectionStarts[i2];
                PsiElement startElement = psiFile.findElementAt(start2);
                if (startElement == null || (endElement = psiFile.findElementAt(end = selectionEnds[i2])) == null || (parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement)) == null) continue;
                PsiElement[] children2 = parent.getChildren();
                TextRange selection = new TextRange(start2, end);
                for (PsiElement child2 : children2) {
                    if (child2 instanceof PsiWhiteSpace || child2.getContainingFile() == null || !selection.contains(child2.getTextOffset())) continue;
                    elements2.add(child2);
                }
            }
            this.myPsiElements = elements2.toArray(PsiElement.EMPTY_ARRAY);
        });
    }

    private PsiElement[] getPsiElements() {
        if (this.myPsiElements == null) {
            this.init();
        }
        return this.myPsiElements;
    }

    private TextRange[] getRanges() {
        this.initVirtualFilesAndRanges();
        return this.myRanges;
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor, Project project, @NotNull String displayName) {
        this(editor, project, displayName, false);
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor, Project project, @NotNull String displayName, boolean ignoreInjectedPsi) {
        super(PsiElement.EMPTY_ARRAY);
        this.myEditor = editor;
        this.myProject = project;
        this.myDisplayName = displayName;
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public VirtualFile @NotNull [] getVirtualFiles() {
        this.initVirtualFilesAndRanges();
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        TextRange[] otherRanges;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditorSelectionLocalSearchScope)) {
            return false;
        }
        EditorSelectionLocalSearchScope other = (EditorSelectionLocalSearchScope)((Object)o);
        VirtualFile[] files2 = this.getVirtualFiles();
        VirtualFile[] otherFiles = other.getVirtualFiles();
        if (!Comparing.equal((Object)files2.length, (Object)otherFiles.length)) {
            return false;
        }
        if (files2.length > 0 && !Comparing.equal((Object)files2[0], (Object)otherFiles[0])) {
            return false;
        }
        TextRange[] ranges = this.getRanges();
        if (ranges.length != (otherRanges = other.getRanges()).length) {
            return false;
        }
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            if (Comparing.equal((Object)ranges[i2], (Object)otherRanges[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        TextRange[] ranges = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            builder2.append(files2[0].toString());
        }
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            if (i2 > 0) {
                builder2.append(',');
            }
            builder2.append('{');
            builder2.append(ranges[i2].toString());
            builder2.append('}');
        }
        return builder2.toString();
    }

    protected int calcHashCode() {
        int result2 = 0;
        TextRange[] ranges = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            result2 += files2[0].hashCode();
        }
        for (TextRange range2 : ranges) {
            result2 += range2.hashCode();
        }
        return result2;
    }

    public boolean containsRange(@NotNull PsiFile file2, @NotNull TextRange range2) {
        TextRange[] ranges;
        VirtualFile[] files2;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = file2.getNavigationElement().getContainingFile().getVirtualFile();
        }
        if ((files2 = this.getVirtualFiles()).length == 0) {
            return false;
        }
        if (!files2[0].equals(virtualFile)) {
            return false;
        }
        for (TextRange textRange : ranges = this.getRanges()) {
            if (!textRange.contains(range2)) continue;
            return true;
        }
        return false;
    }

    private void createIfNeeded() {
        if (this.myLocalSearchScope == null) {
            this.myLocalSearchScope = new LocalSearchScope(this.getPsiElements(), this.myDisplayName, this.myIgnoreInjectedPsi);
        }
    }

    public PsiElement @NotNull [] getScope() {
        this.createIfNeeded();
        return this.myLocalSearchScope.getScope();
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        this.createIfNeeded();
        return this.myLocalSearchScope.intersectWith(scope2);
    }

    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        this.createIfNeeded();
        return this.myLocalSearchScope.intersectWith(scope2);
    }

    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        this.createIfNeeded();
        return this.myLocalSearchScope.union(scope);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        this.createIfNeeded();
        return this.myLocalSearchScope.contains(file2);
    }

    public boolean isInScope(@NotNull VirtualFile file2) {
        this.createIfNeeded();
        return this.myLocalSearchScope.isInScope(file2);
    }
}

