/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.EditorSelectionLocalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredefinedSearchScopeProviderImpl
extends PredefinedSearchScopeProvider {
    @Override
    @NotNull
    public List<SearchScope> getPredefinedScopes(@NotNull Project project, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
        SelectionModel selectionModel;
        PsiFile psiFile;
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        result2.add(GlobalSearchScope.everythingScope((Project)project));
        result2.add(GlobalSearchScope.projectScope((Project)project));
        if (suggestSearchInLibs) {
            result2.add(GlobalSearchScope.allScope((Project)project));
        }
        DataContext adjustedContext = dataContext != null ? dataContext : SimpleDataContext.getProjectContext(project);
        for (SearchScopeProvider each : (SearchScopeProvider[])SearchScopeProvider.EP_NAME.getExtensions()) {
            result2.addAll(each.getGeneralSearchScopes(project, adjustedContext));
        }
        if (ModuleUtil.hasTestSourceRoots((Project)project)) {
            result2.add(GlobalSearchScopesCore.projectProductionScope((Project)project));
            result2.add(GlobalSearchScopesCore.projectTestScope((Project)project));
        }
        result2.add(ScratchesSearchScope.getScratchesScope(project));
        GlobalSearchScope recentFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project, false);
        ContainerUtil.addIfNotNull(result2, (Object)(recentFilesScope != GlobalSearchScope.EMPTY_SCOPE ? recentFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message((String)"scope.recent.files", (Object[])new Object[0])) : null)));
        GlobalSearchScope recentModFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project, true);
        ContainerUtil.addIfNotNull(result2, (Object)(recentModFilesScope != GlobalSearchScope.EMPTY_SCOPE ? recentModFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message((String)"scope.recent.modified.files", (Object[])new Object[0])) : null)));
        GlobalSearchScope openFilesScope = GlobalSearchScopes.openFilesScope((Project)project);
        ContainerUtil.addIfNotNull(result2, (Object)(openFilesScope != GlobalSearchScope.EMPTY_SCOPE ? openFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message((String)"scope.open.files", (Object[])new Object[0])) : null)));
        Editor selectedTextEditor = ApplicationManager.getApplication().isDispatchThread() ? FileEditorManager.getInstance((Project)project).getSelectedTextEditor() : null;
        PsiFile currentFile = psiFile = selectedTextEditor == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedTextEditor.getDocument());
        if (dataContext != null) {
            PsiElement dataContextElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (dataContextElement == null) {
                dataContextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            if (dataContextElement == null && psiFile != null) {
                dataContextElement = psiFile;
            }
            if (dataContextElement != null) {
                if (!PlatformUtils.isCidr() && !PlatformUtils.isRider()) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dataContextElement);
                    if (module == null) {
                        module = (Module)LangDataKeys.MODULE.getData(dataContext);
                    }
                    if (module != null && !ModuleType.isInternal((Module)module)) {
                        result2.add(module.getModuleScope());
                    }
                }
                if (currentFile == null) {
                    currentFile = dataContextElement.getContainingFile();
                }
            }
        }
        if (currentFile != null || showEmptyScopes) {
            PsiElement[] psiElementArray;
            if (currentFile != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = currentFile;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            PsiElement[] scope = psiElementArray;
            result2.add(new LocalSearchScope(scope, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
        }
        if (currentSelection && selectedTextEditor != null && psiFile != null && (selectionModel = selectedTextEditor.getSelectionModel()).hasSelection()) {
            result2.add((Object)new EditorSelectionLocalSearchScope(selectedTextEditor, project, IdeBundle.message((String)"scope.selection", (Object[])new Object[0])));
        }
        if (usageView) {
            PredefinedSearchScopeProviderImpl.addHierarchyScope(project, result2);
            UsageView selectedUsageView = UsageViewManager.getInstance((Project)project).getSelectedUsageView();
            if (selectedUsageView != null && !selectedUsageView.isSearchInProgress()) {
                THashSet usages = new THashSet((Collection)selectedUsageView.getUsages());
                usages.removeAll(selectedUsageView.getExcludedUsages());
                if (prevSearchFiles) {
                    Set<VirtualFile> files2 = PredefinedSearchScopeProviderImpl.collectFiles((Set<? extends Usage>)usages, true);
                    if (!files2.isEmpty()) {
                        GlobalSearchScope prev = new GlobalSearchScope(project, (Set)usages){
                            private Set<VirtualFile> myFiles;
                            final /* synthetic */ Set val$usages;
                            {
                                this.val$usages = set;
                                super(x0);
                            }

                            @NotNull
                            public String getDisplayName() {
                                return IdeBundle.message((String)"scope.files.in.previous.search.result", (Object[])new Object[0]);
                            }

                            public synchronized boolean contains(@NotNull VirtualFile file2) {
                                if (this.myFiles == null) {
                                    this.myFiles = PredefinedSearchScopeProviderImpl.collectFiles(this.val$usages, false);
                                }
                                return this.myFiles.contains(file2);
                            }

                            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                                return true;
                            }

                            public boolean isSearchInLibraries() {
                                return true;
                            }
                        };
                        result2.add(prev);
                    }
                } else {
                    ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
                    for (Usage usage : usages) {
                        PsiElement element2;
                        if (!(usage instanceof PsiElementUsage) || (element2 = ((PsiElementUsage)usage).getElement()) == null || !element2.isValid() || element2.getContainingFile() == null) continue;
                        results.add(element2);
                    }
                    if (!results.isEmpty()) {
                        result2.add(new LocalSearchScope(PsiUtilCore.toPsiElementArray(results), IdeBundle.message((String)"scope.previous.search.results", (Object[])new Object[0])));
                    }
                }
            }
        }
        ContainerUtil.addIfNotNull(result2, (Object)PredefinedSearchScopeProviderImpl.getSelectedFilesScope(project, dataContext, currentFile));
        return new ArrayList<SearchScope>(result2);
    }

    private static void addHierarchyScope(@NotNull Project project, Collection<? super SearchScope> result2) {
        HierarchyBrowserBase hierarchyBrowserBase;
        PsiElement[] elements2;
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Hierarchy");
        if (toolWindow == null) {
            return;
        }
        ContentManager contentManager2 = toolWindow.getContentManager();
        Content content2 = contentManager2.getSelectedContent();
        if (content2 == null) {
            return;
        }
        String name = content2.getDisplayName();
        JComponent component2 = content2.getComponent();
        if (component2 instanceof DumbUnawareHider) {
            component2 = ((DumbUnawareHider)component2).getContent();
        }
        if ((elements2 = (hierarchyBrowserBase = (HierarchyBrowserBase)((Object)component2)).getAvailableElements()).length > 0) {
            result2.add((SearchScope)new LocalSearchScope(elements2, "Hierarchy '" + name + "' (visible nodes only)"));
        }
    }

    @NotNull
    public static GlobalSearchScope recentFilesScope(@NotNull Project project, boolean changedOnly) {
        String name = changedOnly ? IdeBundle.message((String)"scope.recent.modified.files", (Object[])new Object[0]) : IdeBundle.message((String)"scope.recent.files", (Object[])new Object[0]);
        List files2 = changedOnly ? Arrays.asList(IdeDocumentHistory.getInstance(project).getChangedFiles()) : JBIterable.from(EditorHistoryManager.getInstance(project).getFileList()).append((Object[])FileEditorManager.getInstance((Project)project).getOpenFiles()).unique().toList();
        return files2.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)name);
    }

    @Nullable
    private static SearchScope getSelectedFilesScope(@NotNull Project project, @Nullable DataContext dataContext, @Nullable PsiFile currentFile) {
        VirtualFile[] filesOrDirs;
        VirtualFile[] virtualFileArray = filesOrDirs = dataContext == null ? null : (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (filesOrDirs == null || filesOrDirs.length == 0 || filesOrDirs.length == 1 && currentFile != null && filesOrDirs[0].equals(currentFile.getVirtualFile())) {
            return null;
        }
        return new SelectedFilesScope(project, filesOrDirs);
    }

    @NotNull
    protected static Set<VirtualFile> collectFiles(Set<? extends Usage> usages, boolean findFirst) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (Usage usage : usages) {
            VirtualFile file2;
            PsiFile psiFile;
            PsiElement psiElement;
            if (!(usage instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage).getElement()) == null || !psiElement.isValid() || (psiFile = psiElement.getContainingFile()) == null || (file2 = psiFile.getVirtualFile()) == null) continue;
            files2.add(file2);
            if (!findFirst) continue;
            return files2;
        }
        return files2;
    }

    static class SelectedFilesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myFiles = new THashSet();
        private final Set<VirtualFile> myDirectories = new THashSet();

        SelectedFilesScope(Project project, VirtualFile ... filesOrDirs) {
            super(project);
            if (filesOrDirs.length == 0) {
                throw new IllegalArgumentException("array is empty");
            }
            for (VirtualFile fileOrDir : filesOrDirs) {
                if (fileOrDir.isDirectory()) {
                    this.myDirectories.add(fileOrDir);
                    continue;
                }
                this.myFiles.add(fileOrDir);
            }
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            for (VirtualFile virtualFile : this.myFiles) {
                if (!virtualFile.equals(file2)) continue;
                return true;
            }
            return VfsUtilCore.isUnder((VirtualFile)file2, this.myDirectories);
        }

        @NotNull
        public String getDisplayName() {
            if (this.myFiles.isEmpty()) {
                return IdeBundle.message((String)"scope.selected.directories", (Object[])new Object[]{this.myDirectories.size()});
            }
            if (this.myDirectories.isEmpty()) {
                return IdeBundle.message((String)"scope.selected.files", (Object[])new Object[]{this.myFiles.size()});
            }
            return IdeBundle.message((String)"scope.selected.files.and.directories", (Object[])new Object[]{this.myFiles.size(), this.myDirectories.size()});
        }
    }
}

