/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.FileColorManager;
import com.intellij.util.TreeItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultSearchScopeProviders {
    private DefaultSearchScopeProviders() {
    }

    @NotNull
    public static GlobalSearchScope wrapNamedScope(@NotNull Project project, @NotNull NamedScope namedScope, boolean colored) {
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
        if (!colored && !(namedScope instanceof WeighedItem)) {
            return scope;
        }
        int weight2 = namedScope instanceof WeighedItem ? ((WeighedItem)namedScope).getWeight() : -1;
        Color color = !colored ? null : FileColorManager.getInstance((Project)project).getScopeColor(namedScope.getName());
        return new MyWeightedScope(scope, weight2, color);
    }

    private static class MyWeightedScope
    extends DelegatingGlobalSearchScope
    implements WeighedItem,
    ColoredItem {
        final int weight;
        final Color color;

        MyWeightedScope(@NotNull GlobalSearchScope scope, int weight2, Color color) {
            super(scope);
            this.weight = weight2;
            this.color = color;
        }

        public int getWeight() {
            return this.weight;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }
    }

    public static class CustomNamed
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return "Other";
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
            NamedScopesHolder[] holders;
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
                NamedScope[] scopes;
                for (NamedScope scope : scopes = holder.getEditableScopes()) {
                    result2.add((SearchScope)DefaultSearchScopeProviders.wrapNamedScope(project, scope, true));
                }
            }
            return result2;
        }
    }

    public static class Favorites
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return "Favorites";
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
            final FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
            if (favoritesManager == null) {
                return Collections.emptyList();
            }
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            for (final String favorite : favoritesManager.getAvailableFavoritesListNames()) {
                List<TreeItem<Pair<AbstractUrl, String>>> rootUrls = favoritesManager.getFavoritesListRootUrls(favorite);
                if (rootUrls.isEmpty()) continue;
                result2.add((SearchScope)new GlobalSearchScope(project){

                    @NotNull
                    public String getDisplayName() {
                        return "Favorite '" + favorite + "'";
                    }

                    public boolean contains(@NotNull VirtualFile file2) {
                        return (Boolean)ReadAction.compute(() -> favoritesManager.contains(favorite, file2));
                    }

                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        return true;
                    }

                    public boolean isSearchInLibraries() {
                        return true;
                    }
                });
            }
            return result2;
        }
    }
}

