/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import org.jetbrains.annotations.NotNull;

class VirtualFileWindowImpl
extends com.intellij.injected.editor.VirtualFileWindowImpl
implements VirtualFileWindow {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VirtualFileWindowImpl.class);
    private final VirtualFile myDelegate;
    private final DocumentWindowImpl myDocumentWindow;

    VirtualFileWindowImpl(@NotNull String name, @NotNull VirtualFile delegate, @NotNull DocumentWindowImpl window, @NotNull Language language, @NotNull CharSequence text) {
        super(name, language, text);
        this.setCharset(delegate.getCharset(), null, false);
        this.setFileType((FileType)language.getAssociatedFileType());
        if (delegate instanceof VirtualFileWindow) {
            throw new IllegalArgumentException(delegate + " must not be injected");
        }
        this.myDelegate = delegate;
        this.myDocumentWindow = window;
    }

    @Override
    @NotNull
    public VirtualFile getDelegate() {
        return this.myDelegate;
    }

    @NotNull
    public DocumentWindowImpl getDocumentWindow() {
        return this.myDocumentWindow;
    }

    public boolean isValid() {
        return this.myDelegate.isValid() && this.myDocumentWindow.isValid();
    }

    public String toString() {
        return "VirtualFileWindow in " + this.myDelegate.getPresentableUrl();
    }

    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    public void setWritable(boolean writable) {
        LOG.error("Operation is not supported");
    }
}

