/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    SelectionModelWindow(EditorEx delegate, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate.getSelectionModel();
    }

    @NotNull
    public Editor getEditor() {
        return this.myInjectedEditor;
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionStart());
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionEnd());
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.myHostModel.hasSelection(anyCaret);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        this.myHostModel.addSelectionListener(listener2);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        this.myHostModel.removeSelectionListener(listener2);
    }

    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    public int @NotNull [] getBlockSelectionStarts() {
        int[] result2 = this.myHostModel.getBlockSelectionStarts();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.myDocument.hostToInjected(result2[i2]);
        }
        return result2;
    }

    public int @NotNull [] getBlockSelectionEnds() {
        int[] result2 = this.myHostModel.getBlockSelectionEnds();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.myDocument.hostToInjected(result2[i2]);
        }
        return result2;
    }

    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }
}

