/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class MultipleRootsInjectedFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements FreeThreadedFileViewProvider,
InjectedFileViewProvider {
    private final Object myLock = new Object();
    private final DocumentWindowImpl myDocumentWindow;
    private final Language myLanguage;
    private boolean myPatchingLeaves;
    protected final AbstractFileViewProvider myOriginalProvider;

    MultipleRootsInjectedFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull DocumentWindowImpl documentWindow, @NotNull Language language, @NotNull AbstractFileViewProvider original) {
        super(psiManager, (VirtualFile)virtualFile, true);
        this.myDocumentWindow = documentWindow;
        this.myLanguage = language;
        this.myOriginalProvider = original;
    }

    @Override
    public Object getLock() {
        return this.myLock;
    }

    @Override
    public boolean getPatchingLeaves() {
        return this.myPatchingLeaves;
    }

    @Override
    public FileViewProvider clone() {
        return this.cloneImpl();
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        super.rootChanged(psiFile);
        this.rootChangedImpl(psiFile);
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.isEventSystemEnabledImpl();
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysicalImpl();
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        return this.myLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        AbstractFileViewProvider original = this.myOriginalProvider;
        Set languages = original.getLanguages();
        Language base = original.getBaseLanguage();
        return ContainerUtil.map2Set((Collection)languages, language -> language == base ? this.myLanguage : language);
    }

    @Override
    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        FileViewProvider originalProvider = this.getManager().getFileManager().createFileViewProvider(fileCopy, false);
        assert (originalProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) : "Original provider " + originalProvider + " is not multi-root for " + fileCopy + ", cached provider: " + (Object)((Object)this.myOriginalProvider);
        return (MultiplePsiFilesPerDocumentFileViewProvider)originalProvider;
    }

    @Override
    @NotNull
    public DocumentWindowImpl getDocument() {
        return this.myDocumentWindow;
    }

    @Override
    @NonNls
    public String toString() {
        return "Multi root injected file '" + this.getVirtualFile().getName() + "' " + (this.isValid() ? "" : " invalid") + (this.isPhysical() ? "" : " nonphysical");
    }

    @Override
    public final void forceCachedPsi(@NotNull PsiFile psiFile) {
        this.myRoots.put(psiFile.getLanguage(), (PsiFileImpl)psiFile);
        this.getManager().getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    public void doNotInterruptMeWhileImPatchingLeaves(@NotNull Runnable runnable2) {
        this.myPatchingLeaves = true;
        try {
            runnable2.run();
        }
        finally {
            this.myPatchingLeaves = false;
        }
    }

    static final class Template
    extends MultipleRootsInjectedFileViewProvider
    implements TemplateLanguageFileViewProvider {
        Template(@NotNull PsiManagerEx psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull DocumentWindowImpl documentWindow, @NotNull Language language, AbstractFileViewProvider original) {
            super(psiManager, virtualFile, documentWindow, language, original);
            assert (this.myOriginalProvider instanceof TemplateLanguageFileViewProvider);
        }

        @NotNull
        public Language getTemplateDataLanguage() {
            return ((TemplateLanguageFileViewProvider)this.myOriginalProvider).getTemplateDataLanguage();
        }

        public IElementType getContentElementType(@NotNull Language language) {
            return ((TemplateLanguageFileViewProvider)this.myOriginalProvider).getContentElementType(language);
        }
    }
}

